/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.traversal;

import org.neo4j.annotations.api.PublicApi;
import org.neo4j.graphdb.traversal.AlternatingSelectorOrderer;
import org.neo4j.graphdb.traversal.BranchSelector;
import org.neo4j.graphdb.traversal.LevelSelectorOrderer;
import org.neo4j.graphdb.traversal.SideSelector;
import org.neo4j.graphdb.traversal.SideSelectorPolicy;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@PublicApi
public enum SideSelectorPolicies implements SideSelectorPolicy
{
    LEVEL{

        @Override
        public SideSelector create(BranchSelector start, BranchSelector end, int maxDepth) {
            return new LevelSelectorOrderer(start, end, false, maxDepth);
        }
    }
    ,
    LEVEL_STOP_DESCENT_ON_RESULT{

        @Override
        public SideSelector create(BranchSelector start, BranchSelector end, int maxDepth) {
            return new LevelSelectorOrderer(start, end, true, maxDepth);
        }
    }
    ,
    ALTERNATING{

        @Override
        public SideSelector create(BranchSelector start, BranchSelector end, int maxDepth) {
            return new AlternatingSelectorOrderer(start, end);
        }
    };

}

