/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.traversal;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.neo4j.annotations.api.PublicApi;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;

@PublicApi
public class Paths {
    private Paths() {
    }

    public static <T extends Path> String pathToString(T path, PathDescriptor<T> builder) {
        Node current = path.startNode();
        StringBuilder result = new StringBuilder();
        for (Relationship rel : path.relationships()) {
            result.append(builder.nodeRepresentation(path, current));
            result.append(builder.relationshipRepresentation(path, current, rel));
            current = rel.getOtherNode(current);
        }
        if (null != current) {
            result.append(builder.nodeRepresentation(path, current));
        }
        return result.toString();
    }

    public static String defaultPathToString(Path path) {
        return Paths.pathToString(path, new DefaultPathDescriptor());
    }

    public static String simplePathToString(Path path) {
        return Paths.pathToString(path, new DefaultPathDescriptor<Path>(){

            @Override
            public String relationshipRepresentation(Path path, Node from, Relationship relationship) {
                return relationship.getStartNode().equals(from) ? "-->" : "<--";
            }
        });
    }

    public static String simplePathToString(Path path, final String nodePropertyKey) {
        return Paths.pathToString(path, new DefaultPathDescriptor<Path>(){

            @Override
            public String nodeRepresentation(Path path, Node node) {
                return "(" + node.getProperty(nodePropertyKey, node.getId()) + ")";
            }

            @Override
            public String relationshipRepresentation(Path path, Node from, Relationship relationship) {
                return relationship.getStartNode().equals(from) ? "-->" : "<--";
            }
        });
    }

    public static <T extends Path> PathDescriptor<T> descriptorForIdAndProperties(final boolean nodeId, final boolean relId, final String ... propertyKeys) {
        return new PathDescriptor<T>(){

            @Override
            public String nodeRepresentation(T path, Node node) {
                String representation = this.representation(node);
                return "(" + (Serializable)(nodeId ? Long.valueOf(node.getId()) : "") + (nodeId && !representation.equals("") ? "," : "") + representation + ")";
            }

            private String representation(Entity entity) {
                StringBuilder builder = new StringBuilder();
                for (String key : propertyKeys) {
                    Object value = entity.getProperty(key, null);
                    if (value == null) continue;
                    if (builder.length() > 0) {
                        builder.append(',');
                    }
                    builder.append(value);
                }
                return builder.toString();
            }

            @Override
            public String relationshipRepresentation(T path, Node from, Relationship relationship) {
                Direction direction = relationship.getEndNode().equals(from) ? Direction.INCOMING : Direction.OUTGOING;
                StringBuilder builder = new StringBuilder();
                if (direction.equals((Object)Direction.INCOMING)) {
                    builder.append('<');
                }
                builder.append("-[" + (Serializable)(relId ? Long.valueOf(relationship.getId()) : ""));
                String representation = this.representation(relationship);
                if (relId && !representation.equals("")) {
                    builder.append(',');
                }
                builder.append(representation);
                builder.append("]-");
                if (direction.equals((Object)Direction.OUTGOING)) {
                    builder.append('>');
                }
                return builder.toString();
            }
        };
    }

    public static Path singleNodePath(Node node) {
        return new SingleNodePath(node);
    }

    public static String defaultPathToStringWithNotInTransactionFallback(Path path) {
        try {
            return Paths.defaultPathToString(path);
        }
        catch (DatabaseShutdownException | NotInTransactionException runtimeException) {
            StringBuilder sb = new StringBuilder();
            for (Relationship rel : path.relationships()) {
                if (sb.length() == 0) {
                    sb.append("(?)");
                }
                sb.append("-[?,").append(rel.getId()).append("]-(?)");
            }
            return sb.toString();
        }
    }

    private static class SingleNodePath
    implements Path {
        private final Node node;

        SingleNodePath(Node node) {
            this.node = node;
        }

        @Override
        public Node startNode() {
            return this.node;
        }

        @Override
        public Node endNode() {
            return this.node;
        }

        @Override
        public Relationship lastRelationship() {
            return null;
        }

        @Override
        public Iterable<Relationship> relationships() {
            return Collections.emptyList();
        }

        @Override
        public Iterable<Relationship> reverseRelationships() {
            return this.relationships();
        }

        @Override
        public Iterable<Node> nodes() {
            return Arrays.asList(this.node);
        }

        @Override
        public Iterable<Node> reverseNodes() {
            return this.nodes();
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public Iterator<Entity> iterator() {
            return Arrays.asList(this.node).iterator();
        }
    }

    public static class DefaultPathDescriptor<T extends Path>
    implements PathDescriptor<T> {
        @Override
        public String nodeRepresentation(Path path, Node node) {
            return "(" + node.getId() + ")";
        }

        @Override
        public String relationshipRepresentation(Path path, Node from, Relationship relationship) {
            String prefix = "-";
            String suffix = "-";
            if (from.equals(relationship.getEndNode())) {
                prefix = "<-";
            } else {
                suffix = "->";
            }
            return prefix + "[" + relationship.getType().name() + "," + relationship.getId() + "]" + suffix;
        }
    }

    public static interface PathDescriptor<T extends Path> {
        public String nodeRepresentation(T var1, Node var2);

        public String relationshipRepresentation(T var1, Node var2, Relationship var3);
    }
}

