/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.traversal;

import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.impl.traversal.AbstractSelectorOrderer;
import org.neo4j.graphdb.traversal.BranchSelector;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;

public class LevelSelectorOrderer
extends AbstractSelectorOrderer<Entry> {
    private final boolean stopDescentOnResult;
    private final TotalDepth totalDepth = new TotalDepth();
    private final int maxDepth;

    public LevelSelectorOrderer(BranchSelector startSelector, BranchSelector endSelector, boolean stopDescentOnResult, int maxDepth) {
        super(startSelector, endSelector);
        this.stopDescentOnResult = stopDescentOnResult;
        this.maxDepth = maxDepth;
    }

    @Override
    protected Entry initialState() {
        return new Entry();
    }

    @Override
    public TraversalBranch next(TraversalContext metadata) {
        TraversalBranch branch = this.nextBranchFromCurrentSelector(metadata, false);
        Entry state = (Entry)this.getStateForCurrentSelector();
        AtomicInteger previousDepth = state.depth;
        if (branch != null && branch.length() == previousDepth.get()) {
            return branch;
        }
        if (branch != null) {
            this.totalDepth.set(this.currentSide(), branch.length());
        }
        if (this.stopDescentOnResult && metadata.getNumberOfPathsReturned() > 0 || this.totalDepth.get() > this.maxDepth + 1) {
            this.nextSelector();
            return null;
        }
        if (branch != null) {
            previousDepth.set(branch.length());
            state.branch = branch;
        }
        BranchSelector otherSelector = this.nextSelector();
        Entry otherState = (Entry)this.getStateForCurrentSelector();
        TraversalBranch otherBranch = otherState.branch;
        if (otherBranch != null) {
            otherState.branch = null;
            return otherBranch;
        }
        otherBranch = otherSelector.next(metadata);
        return otherBranch != null ? otherBranch : branch;
    }

    private static class TotalDepth {
        private int out;
        private int in;

        private TotalDepth() {
        }

        void set(Direction side, int depth) {
            switch (side) {
                case OUTGOING: {
                    this.out = depth;
                    break;
                }
                case INCOMING: {
                    this.in = depth;
                    break;
                }
            }
        }

        int get() {
            return this.out + this.in;
        }
    }

    static class Entry {
        private final AtomicInteger depth = new AtomicInteger();
        private TraversalBranch branch;

        Entry() {
        }
    }
}

