/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.spatial;

import java.util.Arrays;
import org.neo4j.annotations.api.PublicApi;

@PublicApi
public final class Coordinate {
    private final double[] coordinate;

    public Coordinate(double ... coordinate) {
        if (coordinate.length < 2) {
            throw new IllegalArgumentException("A coordinate must have at least two elements");
        }
        this.coordinate = coordinate;
    }

    public double[] getCoordinate() {
        return this.coordinate;
    }

    public double[] getCoordinateCopy() {
        return Arrays.copyOf(this.coordinate, this.coordinate.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Coordinate that = (Coordinate)o;
        return Arrays.equals(this.coordinate, that.coordinate);
    }

    public int hashCode() {
        return Arrays.hashCode(this.coordinate);
    }
}

