/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.api;

import java.util.List;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.gqlstatus.PrivilegeGqlCodeEntity;

public class DatabaseNotFoundHelper {
    public static DatabaseNotFoundException databaseNotFound(String databaseName) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N51((String)databaseName);
        return new DatabaseNotFoundException(gql, "database not found: " + databaseName);
    }

    public static DatabaseNotFoundException cannotFindDatabase(String databaseName) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N51((String)databaseName);
        return new DatabaseNotFoundException(gql, "Cannot find database: " + databaseName);
    }

    public static DatabaseNotFoundException databaseDoesNotExist(String databaseName) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N51((String)databaseName);
        return new DatabaseNotFoundException(gql, "Database does not exist: " + databaseName);
    }

    public static DatabaseNotFoundException databaseWithNameNotFound(String databaseName) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N51((String)databaseName);
        return new DatabaseNotFoundException(gql, String.format("Database with name `%s` not found.", databaseName));
    }

    public static DatabaseNotFoundException noDatabaseFoundWithNameAlias(String databaseName) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N51((String)databaseName);
        return new DatabaseNotFoundException(gql, String.format("No database found with name/alias '%s'", databaseName));
    }

    public static DatabaseNotFoundException noDatabaseFoundWithNameAliasOnServers(String databaseName, List<String> servers) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N51((String)databaseName);
        return new DatabaseNotFoundException(gql, String.format("No database found with name/alias '%s' on server(s) '%s'", databaseName, servers));
    }

    public static DatabaseNotFoundException defaultDatabaseNotFound(String defaultDatabaseName) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N51((String)defaultDatabaseName);
        return new DatabaseNotFoundException(gql, "Default database not found: " + defaultDatabaseName);
    }

    public static DatabaseNotFoundException failedToRecreateDatabaseNotFound(String databaseName) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N51((String)databaseName);
        return new DatabaseNotFoundException(gql, String.format("Failed to recreate the specified database '%s': No database exists with that name or alias.", databaseName));
    }

    public static DatabaseNotFoundException compositeDatabaseNotFound(String databaseName) {
        ErrorGqlStatusObject gql = PrivilegeGqlCodeEntity.entityNotFound((PrivilegeGqlCodeEntity)PrivilegeGqlCodeEntity.DATABASE, (String)databaseName);
        String message = gql.gqlStatusObject().cause().map(ErrorGqlStatusObject::statusDescription).orElse(gql.statusDescription());
        return new DatabaseNotFoundException(gql, message);
    }

    public static DatabaseNotFoundException failedCreateCompositeAlias(String fullName, String namespaceName) {
        ErrorGqlStatusObject gql = PrivilegeGqlCodeEntity.entityNotFound((PrivilegeGqlCodeEntity)PrivilegeGqlCodeEntity.DATABASE, (String)namespaceName);
        return new DatabaseNotFoundException(gql, String.format("Failed to create the specified database alias '%s': Composite database '%s' does not exist.", fullName, namespaceName));
    }

    public static DatabaseNotFoundException failedCreateAlias(String aliasName, String targetName) {
        ErrorGqlStatusObject gql = PrivilegeGqlCodeEntity.entityNotFound((PrivilegeGqlCodeEntity)PrivilegeGqlCodeEntity.DATABASE, (String)targetName);
        return new DatabaseNotFoundException(gql, String.format("Failed to create the specified database alias '%s': Database '%s' does not exist.", aliasName, targetName));
    }

    public static DatabaseNotFoundException failedDeleteComposite(String name) {
        ErrorGqlStatusObject gql = PrivilegeGqlCodeEntity.entityNotFound((PrivilegeGqlCodeEntity)PrivilegeGqlCodeEntity.DATABASE, (String)name);
        return new DatabaseNotFoundException(gql, String.format("Failed to delete the specified composite database '%s': Database does not exist.", name));
    }

    public static DatabaseNotFoundException failedAction(String action, String name) {
        ErrorGqlStatusObject gql = PrivilegeGqlCodeEntity.entityNotFound((PrivilegeGqlCodeEntity)PrivilegeGqlCodeEntity.DATABASE, (String)name);
        return new DatabaseNotFoundException(gql, String.format("Failed to %s the specified database '%s': Database does not exist.", action, name));
    }

    public static DatabaseNotFoundException failedActionAlias(String action, String alias, String name) {
        ErrorGqlStatusObject gql = PrivilegeGqlCodeEntity.entityNotFound((PrivilegeGqlCodeEntity)PrivilegeGqlCodeEntity.DATABASE, (String)name);
        return new DatabaseNotFoundException(gql, String.format("Failed to %s the specified database alias '%s': Database '%s' does not exist.", action, alias, name));
    }

    public static DatabaseNotFoundException noNameOrAlias(String name) {
        ErrorGqlStatusObject gql = PrivilegeGqlCodeEntity.entityNotFound((PrivilegeGqlCodeEntity)PrivilegeGqlCodeEntity.DATABASE, (String)name);
        return new DatabaseNotFoundException(gql, String.format("Database '%s' does not exist': No database exists with that name or alias.", name));
    }

    public static DatabaseNotFoundException databaseNameNotFoundWithoutDot(String name) {
        ErrorGqlStatusObject gql = PrivilegeGqlCodeEntity.entityNotFound((PrivilegeGqlCodeEntity)PrivilegeGqlCodeEntity.DATABASE, (String)name);
        return new DatabaseNotFoundException(gql, String.format("Database %s not found", name));
    }

    public static DatabaseNotFoundException databaseNameNotFoundWithDot(String name) {
        ErrorGqlStatusObject gql = PrivilegeGqlCodeEntity.entityNotFound((PrivilegeGqlCodeEntity)PrivilegeGqlCodeEntity.DATABASE, (String)name);
        return new DatabaseNotFoundException(gql, String.format("Database %s not found.", name));
    }

    public static DatabaseNotFoundException graphNotFound(String name) {
        ErrorGqlStatusObject gql = PrivilegeGqlCodeEntity.entityNotFound((PrivilegeGqlCodeEntity)PrivilegeGqlCodeEntity.DATABASE, (String)name);
        return new DatabaseNotFoundException(gql, String.format("Graph not found: %s", name));
    }

    public static DatabaseNotFoundException byElementIdFunction(String elementId) {
        ErrorGqlStatusObject gqlStatus = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NA7).withParam(GqlParams.StringParam.db, "graph.byElementId(" + elementId + ")").build()).build();
        return new DatabaseNotFoundException(gqlStatus, "No database is corresponding to `graph.byElementId(" + elementId + ")`. Verify that the elementId is correct.");
    }
}

