/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.Status;

public class TransactionFailureHelper {
    public static final String UNABLE_TO_COMPLETE_TRANSACTION = "Unable to complete transaction.";

    public static TransactionFailureException failToStartTransaction(Throwable e) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N06).build();
        return new TransactionFailureException(gql, "Fail to start new transaction.", e, (Status)Status.Transaction.TransactionStartFailed);
    }

    public static TransactionFailureException genericFailure(Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N02).build();
        return new TransactionFailureException(gql, UNABLE_TO_COMPLETE_TRANSACTION, cause);
    }
}

