/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.api;

import org.neo4j.dbms.api.DatabaseExistsException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.PrivilegeGqlCodeEntity;

public class DatabaseExistsHelper {
    public static DatabaseExistsException failedCreateAliasBecauseDatabaseExists(String databaseName) {
        ErrorGqlStatusObject gql = PrivilegeGqlCodeEntity.entityAlreadyExists((PrivilegeGqlCodeEntity)PrivilegeGqlCodeEntity.DATABASE, (String)databaseName);
        return new DatabaseExistsException(gql, "Failed to create the specified database alias '%s': Database exists with that name.".formatted(databaseName));
    }

    public static DatabaseExistsException failedCreateAliasBecauseAliasExists(String databaseName) {
        ErrorGqlStatusObject gql = PrivilegeGqlCodeEntity.entityAlreadyExists((PrivilegeGqlCodeEntity)PrivilegeGqlCodeEntity.DATABASE, (String)databaseName);
        return new DatabaseExistsException(gql, "Failed to create the specified database alias '%s': Database name or alias already exists.".formatted(databaseName));
    }

    public static DatabaseExistsException failedCreateDatabaseBecauseAliasExists(String databaseName) {
        ErrorGqlStatusObject gql = PrivilegeGqlCodeEntity.entityAlreadyExists((PrivilegeGqlCodeEntity)PrivilegeGqlCodeEntity.DATABASE, (String)databaseName);
        return new DatabaseExistsException(gql, "Failed to create the specified database '%s': Database name or alias already exists.".formatted(databaseName));
    }

    public static DatabaseExistsException failedCreateDatabaseBecausePartAlreadyExists(String ownerDatabaseName, String databaseName) {
        ErrorGqlStatusObject gql = PrivilegeGqlCodeEntity.entityAlreadyExists((PrivilegeGqlCodeEntity)PrivilegeGqlCodeEntity.DATABASE, (String)databaseName);
        return new DatabaseExistsException(gql, "Failed to create the specified database '%s': Part of database '%s' name or alias already exists.".formatted(ownerDatabaseName, databaseName));
    }
}

