/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import java.util.Iterator;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphalgo.impl.util.DijkstraSelectorFactory;
import org.neo4j.graphalgo.impl.util.PathInterest;
import org.neo4j.graphalgo.impl.util.PathInterestFactory;
import org.neo4j.graphalgo.impl.util.WeightedPathIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.InitialBranchState;
import org.neo4j.graphdb.traversal.PathEvaluator;
import org.neo4j.graphdb.traversal.TraversalMetadata;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.internal.helpers.MathUtil;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.impl.traversal.MonoDirectionalTraversalDescription;

public class Dijkstra
implements PathFinder<WeightedPath> {
    private final PathExpander<Double> expander;
    private final InitialBranchState<Double> stateFactory;
    private final CostEvaluator<Double> costEvaluator;
    private Traverser lastTraverser;
    private final double epsilon;
    private final PathInterest<Double> interest;

    public Dijkstra(PathExpander<Double> expander, CostEvaluator<Double> costEvaluator, double epsilon, PathInterest<Double> interest) {
        this.expander = expander;
        this.costEvaluator = costEvaluator;
        this.epsilon = epsilon;
        this.interest = interest;
        this.stateFactory = InitialBranchState.DOUBLE_ZERO;
    }

    @Override
    public Iterable<WeightedPath> findAllPaths(Node start, Node end) {
        Traverser traverser = this.traverser(start, end, this.interest);
        return () -> new WeightedPathIterator((Iterator<Path>)traverser.iterator(), this.costEvaluator, this.epsilon, this.interest);
    }

    private Traverser traverser(Node start, Node end, PathInterest<Double> interest) {
        MutableDouble shortestSoFar = new MutableDouble(Double.MAX_VALUE);
        DijkstraPathExpander dijkstraExpander = new DijkstraPathExpander(this.expander, shortestSoFar, this.epsilon, interest.stopAfterLowestCost());
        DijkstraEvaluator dijkstraEvaluator = new DijkstraEvaluator(shortestSoFar, end, this.costEvaluator);
        this.lastTraverser = new MonoDirectionalTraversalDescription().uniqueness((UniquenessFactory)Uniqueness.NODE_PATH).expand((PathExpander)dijkstraExpander, this.stateFactory).order((BranchOrderingPolicy)new DijkstraSelectorFactory(interest, this.costEvaluator)).evaluator((PathEvaluator)dijkstraEvaluator).traverse(start);
        return this.lastTraverser;
    }

    @Override
    public WeightedPath findSinglePath(Node start, Node end) {
        return (WeightedPath)Iterators.firstOrNull((Iterator)((Object)new WeightedPathIterator((Iterator<Path>)this.traverser(start, end, PathInterestFactory.single(this.epsilon)).iterator(), this.costEvaluator, this.epsilon, this.interest)));
    }

    @Override
    public TraversalMetadata metadata() {
        return this.lastTraverser.metadata();
    }

    private static class DijkstraPathExpander
    implements PathExpander<Double> {
        protected final PathExpander<Double> source;
        protected MutableDouble shortestSoFar;
        private final double epsilon;
        protected final boolean stopAfterLowestCost;

        DijkstraPathExpander(PathExpander<Double> source, MutableDouble shortestSoFar, double epsilon, boolean stopAfterLowestCost) {
            this.source = source;
            this.shortestSoFar = shortestSoFar;
            this.epsilon = epsilon;
            this.stopAfterLowestCost = stopAfterLowestCost;
        }

        public ResourceIterable<Relationship> expand(Path path, BranchState<Double> state) {
            if (MathUtil.compare((double)((Double)state.getState()), (double)this.shortestSoFar.doubleValue(), (double)this.epsilon) > 0 && this.stopAfterLowestCost) {
                return Iterables.emptyResourceIterable();
            }
            return this.source.expand(path, state);
        }

        public PathExpander<Double> reverse() {
            return new DijkstraPathExpander((PathExpander<Double>)this.source.reverse(), this.shortestSoFar, this.epsilon, this.stopAfterLowestCost);
        }
    }

    private static class DijkstraEvaluator
    extends PathEvaluator.Adapter<Double> {
        private final MutableDouble shortestSoFar;
        private final Node endNode;
        private final CostEvaluator<Double> costEvaluator;

        DijkstraEvaluator(MutableDouble shortestSoFar, Node endNode, CostEvaluator<Double> costEvaluator) {
            this.shortestSoFar = shortestSoFar;
            this.endNode = endNode;
            this.costEvaluator = costEvaluator;
        }

        public Evaluation evaluate(Path path, BranchState<Double> state) {
            double nextState = (Double)state.getState();
            if (path.length() > 0) {
                state.setState((Object)(nextState += this.costEvaluator.getCost(path.lastRelationship(), Direction.OUTGOING).doubleValue()));
            }
            if (path.endNode().equals(this.endNode)) {
                this.shortestSoFar.setValue(Math.min(this.shortestSoFar.doubleValue(), nextState));
                return Evaluation.INCLUDE_AND_PRUNE;
            }
            return Evaluation.EXCLUDE_AND_CONTINUE;
        }
    }
}

