/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.shortestpath;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPath;
import org.neo4j.graphalgo.impl.shortestpath.Util;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class SingleSourceShortestPathBFS
implements SingleSourceShortestPath<Integer> {
    protected Node startNode;
    protected Direction relationShipDirection;
    protected RelationshipType[] relationShipTypes;
    protected Map<Node, Integer> distances = new HashMap<Node, Integer>();
    protected Map<Node, List<Relationship>> predecessors = new HashMap<Node, List<Relationship>>();
    protected long maxDepth = Long.MAX_VALUE;
    protected long depth;
    LinkedList<Node> currentLayer = new LinkedList();
    LinkedList<Node> nextLayer = new LinkedList();

    public SingleSourceShortestPathBFS(Node startNode, Direction relationShipDirection, RelationshipType ... relationShipTypes) {
        this.startNode = startNode;
        this.relationShipDirection = relationShipDirection;
        this.relationShipTypes = relationShipTypes;
        this.reset();
    }

    public void limitDepth(long maxDepth) {
        this.maxDepth = maxDepth;
    }

    @Override
    public void setStartNode(Node node) {
        this.startNode = node;
        this.reset();
    }

    @Override
    public void reset() {
        this.distances = new HashMap<Node, Integer>();
        this.predecessors = new HashMap<Node, List<Relationship>>();
        this.currentLayer = new LinkedList();
        this.nextLayer = new LinkedList();
        this.currentLayer.add(this.startNode);
        this.depth = 0L;
    }

    @Override
    public Integer getCost(Node targetNode) {
        this.calculate(targetNode);
        return this.distances.get(targetNode);
    }

    @Override
    public List<Entity> getPath(Node targetNode) {
        if (targetNode == null) {
            throw new RuntimeException("No end node defined");
        }
        this.calculate(targetNode);
        if (!this.distances.containsKey(targetNode)) {
            return null;
        }
        return Util.constructSinglePathToNode(targetNode, this.predecessors, true, false);
    }

    @Override
    public List<Node> getPathAsNodes(Node targetNode) {
        if (targetNode == null) {
            throw new RuntimeException("No end node defined");
        }
        this.calculate(targetNode);
        if (!this.distances.containsKey(targetNode)) {
            return null;
        }
        return Util.constructSinglePathToNodeAsNodes(targetNode, this.predecessors, true, false);
    }

    @Override
    public List<Relationship> getPathAsRelationships(Node targetNode) {
        if (targetNode == null) {
            throw new RuntimeException("No end node defined");
        }
        this.calculate(targetNode);
        if (!this.distances.containsKey(targetNode)) {
            return null;
        }
        return Util.constructSinglePathToNodeAsRelationships(targetNode, this.predecessors, false);
    }

    @Override
    public List<List<Entity>> getPaths(Node targetNode) {
        if (targetNode == null) {
            throw new RuntimeException("No end node defined");
        }
        this.calculate(targetNode);
        if (!this.distances.containsKey(targetNode)) {
            return null;
        }
        return Util.constructAllPathsToNode(targetNode, this.predecessors, true, false);
    }

    @Override
    public List<List<Node>> getPathsAsNodes(Node targetNode) {
        if (targetNode == null) {
            throw new RuntimeException("No end node defined");
        }
        this.calculate(targetNode);
        if (!this.distances.containsKey(targetNode)) {
            return null;
        }
        return Util.constructAllPathsToNodeAsNodes(targetNode, this.predecessors, true, false);
    }

    @Override
    public List<List<Relationship>> getPathsAsRelationships(Node targetNode) {
        if (targetNode == null) {
            throw new RuntimeException("No end node defined");
        }
        this.calculate(targetNode);
        if (!this.distances.containsKey(targetNode)) {
            return null;
        }
        return Util.constructAllPathsToNodeAsRelationships(targetNode, this.predecessors, false);
    }

    public boolean processNextNode() {
        Node node;
        if (this.currentLayer.isEmpty()) {
            if (this.nextLayer.isEmpty()) {
                return false;
            }
            this.currentLayer = this.nextLayer;
            this.nextLayer = new LinkedList();
            ++this.depth;
        }
        if (this.distances.containsKey(node = this.currentLayer.poll())) {
            return true;
        }
        this.distances.put(node, (int)this.depth);
        for (RelationshipType relationshipType : this.relationShipTypes) {
            for (Relationship relationship : node.getRelationships(this.relationShipDirection, new RelationshipType[]{relationshipType})) {
                Node targetNode = relationship.getOtherNode(node);
                if (this.distances.containsKey(targetNode)) continue;
                this.nextLayer.add(targetNode);
                List targetPreds = this.predecessors.computeIfAbsent(targetNode, k -> new LinkedList());
                targetPreds.add(relationship);
            }
        }
        return true;
    }

    public boolean calculate() {
        return this.calculate(null);
    }

    public boolean calculate(Node targetNode) {
        while (!(this.depth > this.maxDepth || targetNode != null && this.distances.containsKey(targetNode))) {
            if (this.processNextNode()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Node> getPredecessorNodes(Node node) {
        LinkedList<Node> result = new LinkedList<Node>();
        List<Relationship> predecessorRelationShips = this.predecessors.get(node);
        if (predecessorRelationShips == null || predecessorRelationShips.isEmpty()) {
            return null;
        }
        for (Relationship relationship : predecessorRelationShips) {
            result.add(relationship.getOtherNode(node));
        }
        return result;
    }

    @Override
    public Map<Node, List<Relationship>> getPredecessors() {
        this.calculate();
        return this.predecessors;
    }

    @Override
    public Direction getDirection() {
        return this.relationShipDirection;
    }

    @Override
    public RelationshipType[] getRelationshipTypes() {
        return this.relationShipTypes;
    }
}

