/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import org.neo4j.graphalgo.EvaluationContext;
import org.neo4j.graphalgo.impl.path.TraversalPathFinder;
import org.neo4j.graphalgo.impl.util.LiteDepthFirstSelector;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;

public class ExactDepthPathFinder
extends TraversalPathFinder {
    private final EvaluationContext context;
    private final PathExpander expander;
    private final int onDepth;
    private final int startThreshold;
    private final Uniqueness uniqueness;

    public ExactDepthPathFinder(EvaluationContext context, PathExpander expander, int onDepth, int startThreshold, boolean allowLoops) {
        this.context = context;
        this.expander = expander;
        this.onDepth = onDepth;
        this.startThreshold = startThreshold;
        this.uniqueness = allowLoops ? Uniqueness.RELATIONSHIP_GLOBAL : Uniqueness.NODE_PATH;
    }

    @Override
    protected Traverser instantiateTraverser(Node start, Node end) {
        Transaction transaction = this.context.transaction();
        TraversalDescription side = transaction.traversalDescription().breadthFirst().uniqueness((UniquenessFactory)this.uniqueness).order((startSource, expander) -> new LiteDepthFirstSelector(startSource, this.startThreshold, expander));
        return transaction.bidirectionalTraversalDescription().startSide(side.expand(this.expander).evaluator(Evaluators.toDepth((int)(this.onDepth / 2)))).endSide(side.expand(this.expander.reverse()).evaluator(Evaluators.toDepth((int)(this.onDepth - this.onDepth / 2)))).collisionEvaluator(Evaluators.atDepth((int)this.onDepth)).traverse(start, end);
    }
}

