/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.shortestpath;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.neo4j.graphalgo.CostAccumulator;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.impl.shortestpath.Dijkstra;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPath;
import org.neo4j.graphalgo.impl.shortestpath.Util;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class SingleSourceShortestPathDijkstra<CostType>
extends Dijkstra<CostType>
implements SingleSourceShortestPath<CostType> {
    Dijkstra.DijkstraIterator dijkstraIterator;
    protected HashMap<Node, CostType> distances = new HashMap();

    public SingleSourceShortestPathDijkstra(CostType startCost, Node startNode, CostEvaluator<CostType> costEvaluator, CostAccumulator<CostType> costAccumulator, Comparator<CostType> costComparator, Direction relationDirection, RelationshipType ... costRelationTypes) {
        super(startCost, startNode, null, costEvaluator, costAccumulator, costComparator, relationDirection, costRelationTypes);
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.distances = new HashMap();
        HashMap seen1 = new HashMap();
        HashMap seen2 = new HashMap();
        HashMap dists2 = new HashMap();
        this.dijkstraIterator = new Dijkstra.DijkstraIterator(this.startNode, this.predecessors1, seen1, seen2, this.distances, dists2, false);
    }

    public boolean calculateMultiple(Node targetNode) {
        if (!this.calculateAllShortestPaths) {
            this.reset();
            this.calculateAllShortestPaths = true;
        }
        return this.calculate(targetNode);
    }

    @Override
    public boolean calculate() {
        return this.calculate(null);
    }

    public boolean calculate(Node targetNode) {
        while (!(targetNode != null && this.distances.containsKey(targetNode) || !this.dijkstraIterator.hasNext() || this.limitReached())) {
            this.dijkstraIterator.next();
        }
        return true;
    }

    @Override
    public void setEndNode(Node endNode) {
        this.endNode = endNode;
    }

    @Override
    public CostType getCost(Node targetNode) {
        if (targetNode == null) {
            throw new RuntimeException("No end node defined");
        }
        this.calculate(targetNode);
        return this.distances.get(targetNode);
    }

    @Override
    public List<List<PropertyContainer>> getPaths(Node targetNode) {
        if (targetNode == null) {
            throw new RuntimeException("No end node defined");
        }
        this.calculateMultiple(targetNode);
        if (!this.distances.containsKey(targetNode)) {
            return null;
        }
        return new LinkedList<List<PropertyContainer>>(Util.constructAllPathsToNode(targetNode, this.predecessors1, true, false));
    }

    @Override
    public List<List<Node>> getPathsAsNodes(Node targetNode) {
        if (targetNode == null) {
            throw new RuntimeException("No end node defined");
        }
        this.calculateMultiple(targetNode);
        if (!this.distances.containsKey(targetNode)) {
            return null;
        }
        return new LinkedList<List<Node>>(Util.constructAllPathsToNodeAsNodes(targetNode, this.predecessors1, true, false));
    }

    @Override
    public List<List<Relationship>> getPathsAsRelationships(Node targetNode) {
        if (targetNode == null) {
            throw new RuntimeException("No end node defined");
        }
        this.calculateMultiple(targetNode);
        if (!this.distances.containsKey(targetNode)) {
            return null;
        }
        return new LinkedList<List<Relationship>>(Util.constructAllPathsToNodeAsRelationships(targetNode, this.predecessors1, false));
    }

    @Override
    public List<PropertyContainer> getPath(Node targetNode) {
        if (targetNode == null) {
            throw new RuntimeException("No end node defined");
        }
        this.calculate(targetNode);
        if (!this.distances.containsKey(targetNode)) {
            return null;
        }
        return Util.constructSinglePathToNode(targetNode, this.predecessors1, true, false);
    }

    @Override
    public List<Node> getPathAsNodes(Node targetNode) {
        if (targetNode == null) {
            throw new RuntimeException("No end node defined");
        }
        this.calculate(targetNode);
        if (!this.distances.containsKey(targetNode)) {
            return null;
        }
        return Util.constructSinglePathToNodeAsNodes(targetNode, this.predecessors1, true, false);
    }

    @Override
    public List<Relationship> getPathAsRelationships(Node targetNode) {
        if (targetNode == null) {
            throw new RuntimeException("No end node defined");
        }
        this.calculate(targetNode);
        if (!this.distances.containsKey(targetNode)) {
            return null;
        }
        return Util.constructSinglePathToNodeAsRelationships(targetNode, this.predecessors1, false);
    }

    @Override
    public CostType getCost() {
        return this.getCost(this.endNode);
    }

    @Override
    public List<PropertyContainer> getPath() {
        return this.getPath(this.endNode);
    }

    @Override
    public List<Node> getPathAsNodes() {
        return this.getPathAsNodes(this.endNode);
    }

    @Override
    public List<Relationship> getPathAsRelationships() {
        return this.getPathAsRelationships(this.endNode);
    }

    @Override
    public List<List<PropertyContainer>> getPaths() {
        return this.getPaths(this.endNode);
    }

    @Override
    public List<List<Node>> getPathsAsNodes() {
        return this.getPathsAsNodes(this.endNode);
    }

    @Override
    public List<List<Relationship>> getPathsAsRelationships() {
        return this.getPathsAsRelationships(this.endNode);
    }

    @Override
    public List<Node> getPredecessorNodes(Node node) {
        LinkedList<Node> result = new LinkedList<Node>();
        List predecessorRelationShips = (List)this.predecessors1.get(node);
        if (predecessorRelationShips == null || predecessorRelationShips.size() == 0) {
            return null;
        }
        for (Relationship relationship : predecessorRelationShips) {
            result.add(relationship.getOtherNode(node));
        }
        return result;
    }

    @Override
    public Map<Node, List<Relationship>> getPredecessors() {
        this.calculateMultiple();
        return this.predecessors1;
    }

    @Override
    public Direction getDirection() {
        return this.relationDirection;
    }

    @Override
    public RelationshipType[] getRelationshipTypes() {
        return this.costRelationTypes;
    }
}

