/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import org.neo4j.graphalgo.impl.path.TraversalPathFinder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.SideSelectorPolicies;
import org.neo4j.graphdb.traversal.SideSelectorPolicy;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;

public class TraversalShortestPath
extends TraversalPathFinder {
    private final PathExpander expander;
    private final int maxDepth;
    private final Integer maxResultCount;

    public TraversalShortestPath(PathExpander expander, int maxDepth) {
        this.expander = expander;
        this.maxDepth = maxDepth;
        this.maxResultCount = null;
    }

    public TraversalShortestPath(PathExpander expander, int maxDepth, int maxResultCount) {
        this.expander = expander;
        this.maxDepth = maxDepth;
        this.maxResultCount = maxResultCount;
    }

    @Override
    protected Traverser instantiateTraverser(Node start, Node end) {
        GraphDatabaseService db = start.getGraphDatabase();
        TraversalDescription sideBase = db.traversalDescription().breadthFirst().uniqueness((UniquenessFactory)Uniqueness.NODE_PATH);
        return db.bidirectionalTraversalDescription().mirroredSides(sideBase.expand(this.expander)).sideSelector((SideSelectorPolicy)SideSelectorPolicies.LEVEL_STOP_DESCENT_ON_RESULT, this.maxDepth).collisionEvaluator(Evaluators.toDepth((int)this.maxDepth)).traverse(start, end);
    }

    @Override
    protected Integer maxResultCount() {
        return this.maxResultCount;
    }
}

