/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphalgo.impl.util.PathInterest;
import org.neo4j.graphalgo.impl.util.PriorityMap;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.BranchSelector;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;

public abstract class BestFirstSelectorFactory<P extends Comparable<P>, D>
implements BranchOrderingPolicy {
    private final PathInterest<P> interest;
    public static final PriorityMap.Converter<Node, TraversalBranch> CONVERTER = new PriorityMap.Converter<Node, TraversalBranch>(){

        @Override
        public Node convert(TraversalBranch source) {
            return source.endNode();
        }
    };

    public BestFirstSelectorFactory(PathInterest<P> interest) {
        this.interest = interest;
    }

    public BranchSelector create(TraversalBranch startSource, PathExpander expander) {
        return new BestFirstSelector(this, startSource, this.getStartData(), expander);
    }

    protected abstract P getStartData();

    protected abstract P addPriority(TraversalBranch var1, P var2, D var3);

    protected abstract D calculateValue(TraversalBranch var1);

    public static final class BestFirstSelector
    implements BranchSelector {
        private final PriorityMap<TraversalBranch, Node, P> queue;
        private TraversalBranch current;
        private P currentAggregatedValue;
        private final PathExpander expander;
        private final Map<Long, Visit<P>> visits;
        final /* synthetic */ BestFirstSelectorFactory this$0;

        public BestFirstSelector(TraversalBranch source, P startData, PathExpander expander) {
            this.this$0 = this$0;
            this.queue = new PriorityMap(CONVERTER, this.this$0.interest.comparator(), this.this$0.interest.stopAfterLowestCost());
            this.visits = new HashMap();
            this.current = source;
            this.currentAggregatedValue = startData;
            this.expander = expander;
        }

        public TraversalBranch next(TraversalContext metadata) {
            PriorityMap.Entry entry;
            TraversalBranch next;
            while ((next = this.current.next(this.expander, metadata)) != null) {
                boolean newStay;
                long endNodeId = next.endNode().getId();
                Visit stay = this.visits.get(endNodeId);
                Object cost = this.this$0.calculateValue(next);
                Object newPriority = this.this$0.addPriority(next, this.currentAggregatedValue, cost);
                boolean bl = newStay = stay == null;
                if (newStay) {
                    stay = new Visit(newPriority);
                    this.visits.put(endNodeId, stay);
                }
                if (!newStay && this.this$0.interest.canBeRuledOut(stay.visitCount, newPriority, stay.cost)) continue;
                if (this.this$0.interest.comparator().compare(newPriority, stay.cost) < 0) {
                    stay.cost = newPriority;
                }
                this.queue.put(next, newPriority);
            }
            while ((entry = this.queue.pop()) != null) {
                this.current = entry.getEntity();
                Visit stay = this.visits.get(this.current.endNode().getId());
                stay.visitCount++;
                if (!this.this$0.interest.stillInteresting(stay.visitCount)) continue;
                this.currentAggregatedValue = (Comparable)entry.getPriority();
                return this.current;
            }
            return null;
        }
    }

    private static class Visit<P extends Comparable<P>>
    implements Comparable<P> {
        private P cost;
        private int visitCount;

        Visit(P cost) {
            this.cost = cost;
        }

        @Override
        public int compareTo(P o) {
            return this.cost.compareTo(o);
        }
    }
}

