/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.centrality;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.impl.centrality.EigenvectorCentralityBase;
import org.neo4j.graphalgo.impl.util.MatrixUtil;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public class EigenvectorCentralityArnoldi
extends EigenvectorCentralityBase {
    public EigenvectorCentralityArnoldi(Direction relationDirection, CostEvaluator<Double> costEvaluator, Set<Node> nodeSet, Set<Relationship> relationshipSet, double precision) {
        super(relationDirection, costEvaluator, nodeSet, relationshipSet, precision);
    }

    @Override
    protected int runInternalIteration() {
        int iterations = 3;
        ArrayList<Node> nodes = new ArrayList<Node>(this.nodeSet.size());
        for (Node node : this.nodeSet) {
            nodes.add(node);
        }
        MatrixUtil.DoubleMatrix hMatrix = new MatrixUtil.DoubleMatrix();
        MatrixUtil.DoubleMatrix qMatrix = new MatrixUtil.DoubleMatrix();
        for (int i = 0; i < nodes.size(); ++i) {
            qMatrix.set(0, i, (Double)this.values.get(nodes.get(i)));
        }
        int localIterations = 1;
        while (true) {
            this.incrementTotalIterations();
            Map<Node, Double> newValues = this.processRelationships();
            for (int j = 0; j < localIterations; ++j) {
                int i;
                MatrixUtil.DoubleVector qj = qMatrix.getRow(j);
                double product = 0.0;
                for (i = 0; i < nodes.size(); ++i) {
                    Double d1 = newValues.get(nodes.get(i));
                    Double d2 = qj.get(i);
                    if (d1 == null || d2 == null) continue;
                    product += d1 * d2;
                }
                hMatrix.set(j, localIterations - 1, product);
                if (product == 0.0) continue;
                for (i = 0; i < nodes.size(); ++i) {
                    Double qValue;
                    Node node = (Node)nodes.get(i);
                    Object value = newValues.get(node);
                    if (value == null) {
                        value = 0.0;
                    }
                    if ((qValue = qj.get(i)) == null) continue;
                    newValues.put(node, (Double)value - product * qValue);
                }
            }
            double normalizeFactor = this.normalize(newValues);
            this.values = newValues;
            MatrixUtil.DoubleVector qVector = new MatrixUtil.DoubleVector();
            for (int i = 0; i < nodes.size(); ++i) {
                Node key = (Node)nodes.get(i);
                Double value = newValues.get(key);
                if (value == null) continue;
                qVector.set(i, value);
            }
            qMatrix.setRow(localIterations, qVector);
            if (normalizeFactor == 0.0 || localIterations >= this.nodeSet.size() || localIterations >= iterations) break;
            hMatrix.set(localIterations, localIterations - 1, normalizeFactor);
            ++localIterations;
        }
        Random random = new Random(System.currentTimeMillis());
        MatrixUtil.DoubleVector vector = new MatrixUtil.DoubleVector();
        for (int i = 0; i < this.nodeSet.size(); ++i) {
            vector.set(i, random.nextDouble());
        }
        MatrixUtil.normalize(vector);
        boolean powerDone = false;
        int its = 0;
        double powerPrecision = 0.1;
        while (!powerDone) {
            MatrixUtil.DoubleVector newVector = MatrixUtil.multiply(hMatrix, vector);
            MatrixUtil.normalize(newVector);
            powerDone = true;
            for (Integer index : vector.getIndices()) {
                double factor;
                if (newVector.get(index) == null || !((factor = Math.abs(newVector.get(index) / vector.get(index))) - powerPrecision > 1.0) && !(factor + powerPrecision < 1.0)) continue;
                powerDone = false;
                break;
            }
            vector = newVector;
            if (++its <= 100) continue;
            break;
        }
        MatrixUtil.DoubleVector ritzVector = new MatrixUtil.DoubleVector();
        for (int r = 0; r < this.nodeSet.size(); ++r) {
            for (int c = 0; c < localIterations; ++c) {
                ritzVector.incrementValue(r, vector.get(c) * qMatrix.get(c, r));
            }
        }
        for (int i = 0; i < this.nodeSet.size(); ++i) {
            this.values.put(nodes.get(i), ritzVector.get(i));
        }
        this.normalize(this.values);
        return localIterations;
    }
}

