/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;

class PriorityMap<E, K, P> {
    private static final Converter SELF_KEY = new Converter(){

        public Object convert(Object source) {
            return source;
        }
    };
    private final Converter<K, E> keyFunction;
    private final Comparator<P> order;
    private final Map<K, Node<E, P>> map = new HashMap<K, Node<E, P>>();
    private final PriorityQueue<Node<E, P>> queue = new PriorityQueue(11, new Comparator<Node<E, P>>(){

        @Override
        public int compare(Node<E, P> o1, Node<E, P> o2) {
            return PriorityMap.this.order.compare(o1.priority, o2.priority);
        }
    });

    public static <K, P> PriorityMap<K, K, P> withSelfKey(Comparator<P> priority) {
        return new PriorityMap(SELF_KEY, priority);
    }

    public static <E, K, P extends Comparable<P>> PriorityMap<E, K, P> withNaturalOrder(Converter<K, E> key) {
        return PriorityMap.withNaturalOrder(key, false);
    }

    public static <E, K, P extends Comparable<P>> PriorityMap<E, K, P> withNaturalOrder(Converter<K, E> key, boolean reversed) {
        NaturalPriority priority = new NaturalPriority(reversed);
        return new PriorityMap(key, priority);
    }

    public static <K, P extends Comparable<P>> PriorityMap<K, K, P> withSelfKeyNaturalOrder() {
        return PriorityMap.withSelfKeyNaturalOrder(false);
    }

    public static <K, P extends Comparable<P>> PriorityMap<K, K, P> withSelfKeyNaturalOrder(boolean reversed) {
        NaturalPriority priority = new NaturalPriority(reversed);
        return new PriorityMap(SELF_KEY, priority);
    }

    private PriorityMap(Converter<K, E> key, Comparator<P> priority) {
        this.keyFunction = key;
        this.order = priority;
    }

    public boolean put(E entity, P priority) {
        K key = this.keyFunction.convert(entity);
        Node<E, P> node = this.map.get(key);
        boolean result = false;
        if (node != null) {
            if (priority.equals(node.priority)) {
                node.head = new Link<E>(entity, node.head);
                result = true;
            } else if (this.order.compare(priority, node.priority) < 0) {
                this.queue.remove(node);
                this.put(entity, priority, key);
                result = true;
            }
        } else {
            this.put(entity, priority, key);
            result = true;
        }
        return result;
    }

    private void put(E entity, P priority, K key) {
        Node<E, P> node = new Node<E, P>(entity, priority);
        this.map.put(key, node);
        this.queue.add(node);
    }

    public P get(K key) {
        Node<E, P> node = this.map.get(key);
        if (node == null) {
            return null;
        }
        return node.priority;
    }

    public Entry<E, P> pop() {
        Node<E, P> node = this.queue.peek();
        Entry<E, P> result = null;
        if (node == null) {
            return null;
        }
        if (node.head.next == null) {
            node = this.queue.poll();
            this.map.remove(this.keyFunction.convert(node.head.entity));
            result = new Entry<E, P>(node);
        } else {
            result = new Entry<E, P>(node);
            node.head = node.head.next;
        }
        return result;
    }

    public Entry<E, P> peek() {
        Node<E, P> node = this.queue.peek();
        if (node == null) {
            return null;
        }
        return new Entry<E, P>(node);
    }

    private static class Link<E> {
        final E entity;
        final Link<E> next;

        Link(E entity, Link<E> next) {
            this.entity = entity;
            this.next = next;
        }
    }

    private static class Node<E, P> {
        Link<E> head;
        final P priority;

        Node(E entity, P priority) {
            this.head = new Link<E>(entity, null);
            this.priority = priority;
        }
    }

    private static class NaturalPriority<P extends Comparable<P>>
    implements Comparator<P> {
        private final boolean reversed;

        NaturalPriority(boolean reversed) {
            this.reversed = reversed;
        }

        @Override
        public int compare(P o1, P o2) {
            if (this.reversed) {
                return o2.compareTo(o1);
            }
            return o1.compareTo(o2);
        }
    }

    public static final class Entry<E, P> {
        private final E entity;
        private final P priority;

        private Entry(E entity, P priority) {
            this.entity = entity;
            this.priority = priority;
        }

        Entry(Node<E, P> node) {
            this(node.head.entity, node.priority);
        }

        public E getEntity() {
            return this.entity;
        }

        public P getPriority() {
            return this.priority;
        }
    }

    public static interface Converter<T, S> {
        public T convert(S var1);
    }
}

