/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import java.util.Iterator;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.EstimateEvaluator;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphalgo.impl.util.BestFirstSelectorFactory;
import org.neo4j.graphalgo.impl.util.StopAfterWeightIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.TraversalMetadata;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;

public class TraversalAStar
implements PathFinder<WeightedPath> {
    private final TraversalDescription traversalDescription;
    private final CostEvaluator<Double> costEvaluator;
    private Traverser lastTraverser;
    private final EstimateEvaluator<Double> estimateEvaluator;

    public TraversalAStar(RelationshipExpander expander, CostEvaluator<Double> costEvaluator, EstimateEvaluator<Double> estimateEvaluator) {
        this.traversalDescription = Traversal.traversal().uniqueness((UniquenessFactory)Uniqueness.NONE).expand(expander);
        this.costEvaluator = costEvaluator;
        this.estimateEvaluator = estimateEvaluator;
    }

    @Override
    public Iterable<WeightedPath> findAllPaths(Node start, Node end) {
        this.lastTraverser = this.traversalDescription.order((BranchOrderingPolicy)new SelectorFactory(end)).evaluator(Evaluators.includeWhereEndNodeIs((Node[])new Node[]{end})).traverse(new Node[]{start});
        return new Iterable<WeightedPath>(){

            @Override
            public Iterator<WeightedPath> iterator() {
                return new StopAfterWeightIterator(TraversalAStar.this.lastTraverser.iterator(), TraversalAStar.this.costEvaluator);
            }
        };
    }

    @Override
    public WeightedPath findSinglePath(Node start, Node end) {
        return (WeightedPath)IteratorUtil.firstOrNull(this.findAllPaths(start, end));
    }

    @Override
    public TraversalMetadata metadata() {
        return this.lastTraverser.metadata();
    }

    private class SelectorFactory
    extends BestFirstSelectorFactory<PositionData, Double> {
        private final Node end;

        SelectorFactory(Node end) {
            this.end = end;
        }

        @Override
        protected PositionData addPriority(TraversalBranch source, PositionData currentAggregatedValue, Double value) {
            return new PositionData(currentAggregatedValue.wayLengthG + value, (Double)TraversalAStar.this.estimateEvaluator.getCost(source.endNode(), this.end));
        }

        @Override
        protected Double calculateValue(TraversalBranch next) {
            return next.length() == 0 ? 0.0 : (Double)TraversalAStar.this.costEvaluator.getCost(next.lastRelationship(), Direction.OUTGOING);
        }

        @Override
        protected PositionData getStartData() {
            return new PositionData(0.0, 0.0);
        }
    }

    private static class PositionData
    implements Comparable<PositionData> {
        private final double wayLengthG;
        private final double estimateH;

        public PositionData(double wayLengthG, double estimateH) {
            this.wayLengthG = wayLengthG;
            this.estimateH = estimateH;
        }

        Double f() {
            return this.estimateH + this.wayLengthG;
        }

        @Override
        public int compareTo(PositionData o) {
            return this.f().compareTo(o.f());
        }

        public String toString() {
            return "g:" + this.wayLengthG + ", h:" + this.estimateH;
        }
    }
}

