/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.graphalgo.impl.util.PriorityMap;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.BranchSelector;
import org.neo4j.graphdb.traversal.TraversalBranch;

public abstract class BestFirstSelectorFactory<P extends Comparable<P>, D>
implements BranchOrderingPolicy {
    public static final PriorityMap.Converter<Node, TraversalBranch> CONVERTER = new PriorityMap.Converter<Node, TraversalBranch>(){

        @Override
        public Node convert(TraversalBranch source) {
            return source.node();
        }
    };

    public BranchSelector create(TraversalBranch startSource) {
        return new BestFirstSelector(this, startSource, this.getStartData());
    }

    protected abstract P getStartData();

    protected abstract P addPriority(TraversalBranch var1, P var2, D var3);

    protected abstract D calculateValue(TraversalBranch var1);

    public static final class BestFirstSelector
    implements BranchSelector {
        private PriorityMap<TraversalBranch, Node, P> queue = PriorityMap.withNaturalOrder(CONVERTER);
        private TraversalBranch current;
        private P currentAggregatedValue;
        private final Set<Long> visitedNodes = new HashSet<Long>();
        final /* synthetic */ BestFirstSelectorFactory this$0;

        public BestFirstSelector(TraversalBranch source, P startData) {
            this.this$0 = var1_1;
            this.current = source;
            this.currentAggregatedValue = startData;
        }

        public TraversalBranch next() {
            TraversalBranch next;
            while ((next = this.current.next()) != null) {
                if (this.visitedNodes.contains(next.node().getId())) continue;
                Object newPriority = this.this$0.addPriority(next, this.currentAggregatedValue, this.this$0.calculateValue(next));
                this.queue.put(next, newPriority);
            }
            PriorityMap.Entry entry = this.queue.pop();
            if (entry != null) {
                this.current = entry.getEntity();
                this.currentAggregatedValue = (Comparable)entry.getPriority();
                this.visitedNodes.add(this.current.node().getId());
                return this.current;
            }
            return null;
        }
    }
}

