/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo;

import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.EstimateEvaluator;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphalgo.impl.path.AStar;
import org.neo4j.graphalgo.impl.path.AllPaths;
import org.neo4j.graphalgo.impl.path.AllSimplePaths;
import org.neo4j.graphalgo.impl.path.Dijkstra;
import org.neo4j.graphalgo.impl.path.ShortestPath;
import org.neo4j.graphalgo.impl.util.DoubleEvaluator;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.RelationshipExpander;

public abstract class GraphAlgoFactory {
    public static PathFinder<Path> allPaths(RelationshipExpander expander, int maxDepth) {
        return new AllPaths(maxDepth, expander);
    }

    public static PathFinder<Path> allSimplePaths(RelationshipExpander expander, int maxDepth) {
        return new AllSimplePaths(maxDepth, expander);
    }

    public static PathFinder<Path> shortestPath(RelationshipExpander expander, int maxDepth) {
        return new ShortestPath(maxDepth, expander);
    }

    public static PathFinder<Path> pathsWithLength(RelationshipExpander expander, int length) {
        return new ShortestPath(length, expander, true);
    }

    public static PathFinder<WeightedPath> aStar(RelationshipExpander expander, CostEvaluator<Double> lengthEvaluator, EstimateEvaluator<Double> estimateEvaluator) {
        return new AStar(expander, lengthEvaluator, estimateEvaluator);
    }

    public static PathFinder<WeightedPath> dijkstra(RelationshipExpander expander, CostEvaluator<Double> costEvaluator) {
        return new Dijkstra(expander, costEvaluator);
    }

    public static PathFinder<WeightedPath> dijkstra(RelationshipExpander expander, String relationshipPropertyRepresentingCost) {
        return GraphAlgoFactory.dijkstra(expander, new DoubleEvaluator(relationshipPropertyRepresentingCost));
    }
}

