/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Map;
import org.neo4j.graphalgo.GraphAlgoFactory;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;
import org.neo4j.shell.kernel.apps.ReadOnlyGraphDatabaseApp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathShellApp
extends ReadOnlyGraphDatabaseApp {
    public PathShellApp() {
        this.addOptionDefinition("a", new OptionDefinition(OptionValueType.MUST, "Which algorithm to use"));
        this.addOptionDefinition("m", new OptionDefinition(OptionValueType.MUST, "Maximum depth to traverse"));
        this.addOptionDefinition("f", new OptionDefinition(OptionValueType.MUST, "Relationship types and directions, f.ex: {KNOWS:out,LOVES:both}"));
        this.addOptionDefinition("from", new OptionDefinition(OptionValueType.MUST, "Use some other star point than the current node"));
        this.addOptionDefinition("q", new OptionDefinition(OptionValueType.NONE, "More quiet, print less verbose paths"));
        this.addOptionDefinition("s", new OptionDefinition(OptionValueType.NONE, "Find max one path"));
    }

    public String getDescription() {
        return "Displays paths from current (or any node) to another node using supplied algorithm. Usage:\n\n# Find shortest paths from current to node 241 at max depth 10\npaths -m 10 -a shortestPath -f KNOWS:out,LOVES:in 241";
    }

    public String getName() {
        return "paths";
    }

    protected String exec(AppCommandParser parser, Session session, Output out) throws Exception {
        PathFinder<Path> finder;
        String fromString = (String)parser.options().get("from");
        String toString = (String)parser.arguments().get(0);
        String algo = (String)parser.options().get("a");
        String maxDepthString = (String)parser.options().get("m");
        boolean quietPrint = parser.options().containsKey("q");
        boolean caseInsensitiveFilters = parser.options().containsKey("i");
        boolean looseFilters = parser.options().containsKey("l");
        int maxDepth = maxDepthString != null ? Integer.parseInt(maxDepthString) : Integer.MAX_VALUE;
        fromString = fromString != null ? fromString : String.valueOf(this.getCurrent(session).getId());
        Map filter = PathShellApp.parseFilter((String)((String)parser.options().get("f")), (Output)out);
        RelationshipExpander expander = PathShellApp.toExpander((GraphDatabaseService)this.getServer().getDb(), (Direction)Direction.BOTH, (Map)filter, (boolean)caseInsensitiveFilters, (boolean)looseFilters);
        PathFinder<Path> pathFinder = finder = expander != null ? this.getPathFinder(algo, expander, maxDepth, out) : null;
        if (finder != null) {
            Node fromNode = this.getNodeById(Long.parseLong(fromString));
            Node toNode = this.getNodeById(Long.parseLong(toString));
            boolean single = parser.options().containsKey("s");
            Iterable<Path> paths = single ? Arrays.asList(finder.findSinglePath(fromNode, toNode)) : finder.findAllPaths(fromNode, toNode);
            for (Path path : paths) {
                this.printPath(path, quietPrint, session, out);
            }
        }
        return null;
    }

    private void printPath(Path path, boolean quietPrint, Session session, Output out) throws RemoteException, ShellException {
        StringBuilder builder = new StringBuilder();
        Node currentNode = null;
        for (PropertyContainer entity : path) {
            String display = null;
            if (entity instanceof Relationship) {
                display = quietPrint ? "" : PathShellApp.getDisplayName((GraphDatabaseShellServer)this.getServer(), (Session)session, (Relationship)((Relationship)entity), (boolean)false, (boolean)true);
                display = PathShellApp.withArrows((Relationship)((Relationship)entity), (String)display, (Node)currentNode);
            } else {
                currentNode = (Node)entity;
                display = PathShellApp.getDisplayName((GraphDatabaseShellServer)this.getServer(), (Session)session, (Node)currentNode, (boolean)true);
            }
            builder.append(display);
        }
        out.println((Serializable)((Object)builder.toString()));
    }

    private PathFinder<Path> getPathFinder(String algo, RelationshipExpander expander, int maxDepth, Output out) throws Exception {
        Method method;
        try {
            method = GraphAlgoFactory.class.getDeclaredMethod(algo, RelationshipExpander.class, Integer.TYPE);
        }
        catch (Exception e) {
            out.println((Serializable)((Object)("Couldn't find algorithm '" + algo + "'")));
            return null;
        }
        return (PathFinder)method.invoke(null, expander, maxDepth);
    }
}

