/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.vector.providers.openai;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.OptionalLong;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.multimap.list.MutableListMultimap;
import org.eclipse.collections.impl.factory.Multimaps;
import org.neo4j.genai.util.Client;
import org.neo4j.genai.util.HttpClient;
import org.neo4j.genai.util.JsonResponseParser;
import org.neo4j.genai.vector.MalformedGenAIResponseException;
import org.neo4j.genai.vector.VectorEncoding;
import org.neo4j.util.VisibleForTesting;

public abstract class OpenAIBasedEncoder
implements VectorEncoding.Provider.Encoder {
    private static final String ENCODING_FORMAT = "float";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final HttpClient client;
    private final URI endpoint;
    private final String providerName;
    private final OptionalLong dimensions;

    protected void extendHeaders(MutableMultimap<String, String> headers) {
    }

    protected void extendPayload(MutableMap<String, Object> payload) {
    }

    protected OpenAIBasedEncoder(String providerName, HttpClient client, URI endpoint, OptionalLong dimensions) {
        this.providerName = providerName;
        this.client = client;
        this.endpoint = endpoint;
        this.dimensions = dimensions;
    }

    @Override
    public float[] encode(String data) {
        return this.encode(List.of(data), ArrayUtils.EMPTY_INT_ARRAY).findFirst().orElseThrow().vector();
    }

    @Override
    public Stream<VectorEncoding.BatchRow> encode(List<String> resources, int[] nullIndexes) {
        Stream<VectorEncoding.BatchRow> stream;
        block8: {
            MutableListMultimap headers = Multimaps.mutable.list.of((Object)"Content-Type", (Object)("application/json; charset=" + StandardCharsets.UTF_8), (Object)"Accept", (Object)"application/json");
            this.extendHeaders((MutableMultimap<String, String>)headers);
            Client.Payload payload = writer -> this.writeRequestPayload(writer, resources);
            InputStream inputStream = this.client.sendRequest(this.endpoint, (Multimap<String, String>)headers, payload);
            try {
                stream = this.parseResponse(resources, inputStream, nullIndexes);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    throw new RuntimeException(throwable3);
                }
            }
            inputStream.close();
        }
        return stream;
    }

    private Stream<VectorEncoding.BatchRow> parseResponse(List<String> resources, InputStream inputStream, int[] nullIndexes) {
        return OpenAIBasedEncoder.parseResponse(this.providerName, resources, inputStream, nullIndexes);
    }

    @VisibleForTesting
    public static Stream<VectorEncoding.BatchRow> parseResponse(String providerName, List<String> resources, InputStream inputStream, int[] nullIndexes) throws MalformedGenAIResponseException {
        String[] properties = new String[]{"embedding"};
        return JsonResponseParser.parseResponse(providerName, "data", properties, resources, inputStream, nullIndexes);
    }

    private Object buildPayload(List<String> resources) {
        MutableMap payload = Maps.mutable.of((Object)"input", resources, (Object)"encoding_format", (Object)ENCODING_FORMAT);
        this.dimensions.ifPresent(d -> payload.put((Object)"dimensions", (Object)d));
        this.extendPayload((MutableMap<String, Object>)payload);
        return payload;
    }

    private void writeRequestPayload(Writer writer, List<String> resources) throws IOException {
        OBJECT_MAPPER.writeValue(writer, this.buildPayload(resources));
    }
}

