/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.vector.providers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.api.multimap.list.MutableListMultimap;
import org.eclipse.collections.impl.factory.Multimaps;
import org.neo4j.genai.util.Client;
import org.neo4j.genai.util.HttpClient;
import org.neo4j.genai.util.JsonResponseParser;
import org.neo4j.genai.vector.MalformedGenAIResponseException;
import org.neo4j.genai.vector.VectorEncoding;

public final class VertexAI
implements VectorEncoding.Provider<Parameters> {
    public static final String NAME = "VertexAI";
    private static final String ENDPOINT_TEMPLATE = "https://${region}-aiplatform.googleapis.com/v1/projects/${projectId}/locations/${region}/publishers/google/models/${model}:predict";
    static final String DEFAULT_REGION = "us-central1";
    static final Set<String> SUPPORTED_REGIONS = Set.of("us-west1", "us-west2", "us-west3", "us-west4", "us-central1", "us-east1", "us-east4", "us-south1", "northamerica-northeast1", "northamerica-northeast2", "southamerica-east1", "southamerica-west1", "europe-west2", "europe-west1", "europe-west4", "europe-west6", "europe-west3", "europe-north1", "europe-central2", "europe-west8", "europe-west9", "europe-southwest1", "asia-south1", "asia-southeast1", "asia-southeast2", "asia-east2", "asia-east1", "asia-northeast1", "asia-northeast2", "australia-southeast1", "australia-southeast2", "asia-northeast3", "me-west1");
    private static final String STRINGIFIED_SUPPORTED_REGIONS = SUPPORTED_REGIONS.stream().map(s -> "'" + s + "'").collect(Collectors.joining(", ", "[", "]"));
    static final String DEFAULT_MODEL = "textembedding-gecko@001";
    static final Set<String> SUPPORTED_MODELS = Set.of("textembedding-gecko@001", "textembedding-gecko@002", "textembedding-gecko@003", "textembedding-gecko-multilingual@001");
    private static final String STRINGIFIED_SUPPORTED_MODELS = SUPPORTED_MODELS.stream().map(s -> "'" + s + "'").collect(Collectors.joining(", ", "[", "]"));
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final HttpClient client = new HttpClient();

    @Override
    public Class<Parameters> parameterDeclarations() {
        return Parameters.class;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public VectorEncoding.Provider.Encoder configure(Parameters configuration) {
        if (!SUPPORTED_MODELS.contains(configuration.model)) {
            throw new IllegalArgumentException("Provided model '%s' is not supported. Supported models: %s".formatted(configuration.model, STRINGIFIED_SUPPORTED_MODELS));
        }
        if (!SUPPORTED_REGIONS.contains(configuration.region)) {
            throw new IllegalArgumentException("Provided region '%s' is not supported. Supported regions: %s".formatted(configuration.region, STRINGIFIED_SUPPORTED_REGIONS));
        }
        URI endpoint = URI.create(StringSubstitutor.replace((Object)ENDPOINT_TEMPLATE, Map.of("region", configuration.region, "projectId", configuration.projectId, "model", configuration.model)));
        return new Encoder(this.client, endpoint, configuration);
    }

    public static class Parameters {
        public String token;
        public String projectId;
        public String model = "textembedding-gecko@001";
        public String region = "us-central1";
        public Optional<String> taskType;
        public Optional<String> title;
    }

    record Encoder(HttpClient client, URI endpoint, Parameters configuration) implements VectorEncoding.Provider.Encoder
    {
        @Override
        public float[] encode(String data) {
            return this.encode(List.of(data), ArrayUtils.EMPTY_INT_ARRAY).findFirst().orElseThrow().vector();
        }

        @Override
        public Stream<VectorEncoding.BatchRow> encode(List<String> resources, int[] nullIndexes) {
            Stream<VectorEncoding.BatchRow> stream;
            block8: {
                MutableListMultimap headers = Multimaps.mutable.list.of((Object)"Authorization", (Object)("Bearer " + this.configuration.token), (Object)"Content-Type", (Object)("application/json; charset=" + StandardCharsets.UTF_8), (Object)"Accept", (Object)"application/json");
                Client.Payload payload = writer -> this.writeRequestPayload(writer, resources);
                InputStream inputStream = this.client.sendRequest(this.endpoint, (Multimap<String, String>)headers, payload);
                try {
                    stream = JsonResponseParser.parseResponse(VertexAI.NAME, "predictions", new String[]{"embeddings", "values"}, resources, inputStream, nullIndexes);
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        throw new RuntimeException(throwable3);
                    }
                }
                inputStream.close();
            }
            return stream;
        }

        static Stream<VectorEncoding.BatchRow> parseResponse(List<String> resources, InputStream inputStream, int[] nullIndexes) throws MalformedGenAIResponseException {
            String[] properties = new String[]{"embeddings", "values"};
            return JsonResponseParser.parseResponse(VertexAI.NAME, "predictions", properties, resources, inputStream, nullIndexes);
        }

        private void writeRequestPayload(Writer writer, List<String> resources) throws IOException {
            OBJECT_MAPPER.writeValue(writer, Map.of("instances", resources.stream().map(resource -> {
                MutableMap instance = Maps.mutable.of((Object)"content", resource);
                this.configuration.taskType.ifPresent(x -> instance.put((Object)"task_type", x));
                this.configuration.title.ifPresent(x -> instance.put((Object)"title", x));
                return instance;
            }).toList()));
        }
    }
}

