/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.vector.providers;

import java.net.URI;
import java.util.OptionalLong;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.neo4j.genai.util.HttpClient;
import org.neo4j.genai.vector.VectorEncoding;
import org.neo4j.genai.vector.providers.openai.OpenAIBasedEncoder;

public final class OpenAI
implements VectorEncoding.Provider<Parameters> {
    public static final String NAME = "OpenAI";
    private static final URI ENDPOINT = URI.create("https://api.openai.com/v1/embeddings");
    static final String DEFAULT_MODEL = "text-embedding-ada-002";
    private final HttpClient client = new HttpClient();

    @Override
    public Class<Parameters> parameterDeclarations() {
        return Parameters.class;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public VectorEncoding.Provider.Encoder configure(Parameters configuration) {
        return new Encoder(this.client, ENDPOINT, configuration);
    }

    public static class Parameters {
        public String token;
        public String model = "text-embedding-ada-002";
        public OptionalLong dimensions;
    }

    static class Encoder
    extends OpenAIBasedEncoder {
        private final Parameters configuration;

        Encoder(HttpClient client, URI endpoint, Parameters configuration) {
            super(OpenAI.NAME, client, endpoint, configuration.dimensions);
            this.configuration = configuration;
        }

        @Override
        protected void extendHeaders(MutableMultimap<String, String> headers) {
            headers.put((Object)"Authorization", (Object)("Bearer " + this.configuration.token));
        }

        @Override
        protected void extendPayload(MutableMap<String, Object> payload) {
            payload.put((Object)"model", (Object)this.configuration.model);
        }
    }
}

