/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.vector.providers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.impl.factory.Multimaps;
import org.neo4j.genai.util.CheckedAccessors;
import org.neo4j.genai.util.Client;
import org.neo4j.genai.util.HttpClient;
import org.neo4j.genai.util.aws.AwsSignatureV4HeaderGenerator;
import org.neo4j.genai.vector.MalformedGenAIResponseException;
import org.neo4j.genai.vector.VectorEncoding;

public final class Bedrock
implements VectorEncoding.Provider<Parameters> {
    public static final String NAME = "Bedrock";
    private static final String ENDPOINT_TEMPLATE = "https://bedrock-runtime.${region}.amazonaws.com/model/${model}/invoke";
    static final String DEFAULT_REGION = "us-east-1";
    static final Set<String> SUPPORTED_REGIONS = Set.of("us-east-1", "us-west-2", "ap-southeast-1", "ap-northeast-1", "eu-central-1");
    private static final String STRINGIFIED_SUPPORTED_REGIONS = SUPPORTED_REGIONS.stream().map(s -> "'" + s + "'").collect(Collectors.joining(", ", "[", "]"));
    static final String DEFAULT_MODEL = "amazon.titan-embed-text-v1";
    static final Set<String> SUPPORTED_MODELS = Set.of("amazon.titan-embed-text-v1");
    private static final String STRINGIFIED_SUPPORTED_MODELS = SUPPORTED_MODELS.stream().map(s -> "'" + s + "'").collect(Collectors.joining(", ", "[", "]"));
    private static final TypeReference<float[]> VECTOR_TYPE_REFERENCE = new TypeReference<float[]>(){};
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final HttpClient client = new HttpClient();

    @Override
    public Class<Parameters> parameterDeclarations() {
        return Parameters.class;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public VectorEncoding.Provider.Encoder configure(Parameters configuration) {
        if (!SUPPORTED_MODELS.contains(configuration.model)) {
            throw new IllegalArgumentException("Provided model '%s' is not supported. Supported models: %s".formatted(configuration.model, STRINGIFIED_SUPPORTED_MODELS));
        }
        if (!SUPPORTED_REGIONS.contains(configuration.region)) {
            throw new IllegalArgumentException("Provided region '%s' is not supported. Supported regions: %s".formatted(configuration.region, STRINGIFIED_SUPPORTED_REGIONS));
        }
        URI endpoint = URI.create(StringSubstitutor.replace((Object)ENDPOINT_TEMPLATE, Map.of("region", configuration.region, "model", configuration.model)));
        return new Encoder(this.client, endpoint, configuration);
    }

    public static class Parameters {
        public String accessKeyId;
        public String secretAccessKey;
        public String model = "amazon.titan-embed-text-v1";
        public String region = "us-east-1";
    }

    record Encoder(HttpClient client, URI endpoint, Parameters configuration) implements VectorEncoding.Provider.Encoder
    {
        @Override
        public float[] encode(String resource) {
            float[] fArray;
            block8: {
                String body = this.createRequestBody(resource);
                Multimap<String, String> requestProperties = this.client.prepareRequestProperties(this.endpoint.getHost(), (Multimap<String, String>)Multimaps.mutable.list.of((Object)"Content-Type", (Object)"application/json", (Object)"Accept", (Object)"application/json"));
                Multimap<String, String> headers = new AwsSignatureV4HeaderGenerator(this.configuration.region, this.endpoint, body, requestProperties).generate(this.configuration.accessKeyId, this.configuration.secretAccessKey);
                Client.Payload payload = writer -> writer.write(body);
                InputStream inputStream = this.client.sendRequest(this.endpoint, headers, payload);
                try {
                    fArray = Encoder.parseResponse(inputStream);
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        throw new RuntimeException(throwable3);
                    }
                }
                inputStream.close();
            }
            return fArray;
        }

        static float[] parseResponse(InputStream inputStream) throws MalformedGenAIResponseException {
            float[] fArray;
            block11: {
                JsonNode tree;
                try {
                    tree = OBJECT_MAPPER.readTree(inputStream);
                }
                catch (IOException e) {
                    throw new MalformedGenAIResponseException("Unexpected error occurred while parsing the API response", e);
                }
                JsonNode embedding = Encoder.getExpectedFrom(tree, "embedding");
                if (!embedding.isArray()) {
                    throw new MalformedGenAIResponseException("Expected embedding to be an array");
                }
                JsonParser parser = embedding.traverse((ObjectCodec)OBJECT_MAPPER);
                try {
                    fArray = (float[])parser.readValueAs(VECTOR_TYPE_REFERENCE);
                    if (parser == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new MalformedGenAIResponseException("Unexpected error occurred while parsing the embedding", e);
                    }
                }
                parser.close();
            }
            return fArray;
        }

        private static JsonNode getExpectedFrom(JsonNode json, String property) throws MalformedGenAIResponseException {
            return CheckedAccessors.Json.getExpectedFrom(Bedrock.NAME, json, property);
        }

        private String createRequestBody(String resource) throws IOException {
            return OBJECT_MAPPER.writeValueAsString(Map.of("inputText", resource));
        }
    }
}

