/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public class ParameterValueMapper
implements ValueMapper<Object> {
    private Object unsupported(String thing) {
        throw new IllegalArgumentException("%s are not supported as parameter values".formatted(thing));
    }

    public Object mapPath(VirtualPathValue value) {
        return this.unsupported("paths");
    }

    public Object mapNode(VirtualNodeValue value) {
        return this.unsupported("nodes");
    }

    public Object mapRelationship(VirtualRelationshipValue value) {
        return this.unsupported("relationships");
    }

    public Object mapNoValue() {
        return null;
    }

    public Object mapMap(MapValue value) {
        HashMap map = new HashMap(value.size());
        value.foreach((k, v) -> map.put(k, v.map((ValueMapper)this)));
        return map;
    }

    public List<?> mapSequence(SequenceValue value) {
        int size = value.intSize();
        ArrayList<Object> list = new ArrayList<Object>(size);
        if (value.iterationPreference() == SequenceValue.IterationPreference.RANDOM_ACCESS) {
            for (int i = 0; i < size; ++i) {
                list.add(value.value((long)i).map((ValueMapper)this));
            }
        } else {
            value.forEach(v -> list.add(v.map((ValueMapper)this)));
        }
        return list;
    }

    public Object mapText(TextValue value) {
        return value.stringValue();
    }

    public Object mapBoolean(BooleanValue value) {
        return value.booleanValue();
    }

    public Object mapNumber(NumberValue value) {
        return this.unsupported("numbers");
    }

    public Object mapIntegral(IntegralValue value) {
        return value.longValue();
    }

    public Object mapFloatingPoint(FloatingPointValue value) {
        return value.doubleValue();
    }

    public Object mapDateTime(DateTimeValue value) {
        return value.asObjectCopy();
    }

    public Object mapLocalDateTime(LocalDateTimeValue value) {
        return value.asObjectCopy();
    }

    public Object mapDate(DateValue value) {
        return value.asObjectCopy();
    }

    public Object mapTime(TimeValue value) {
        return value.asObjectCopy();
    }

    public Object mapLocalTime(LocalTimeValue value) {
        return value.asObjectCopy();
    }

    public Object mapDuration(DurationValue value) {
        return value.asObjectCopy();
    }

    public Object mapPoint(PointValue value) {
        return value.asObjectCopy();
    }
}

