/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import java.util.Arrays;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;

public class InvalidSpatialArgumentException
extends InvalidArgumentException {
    public InvalidSpatialArgumentException(String message) {
        super(message);
    }

    public InvalidSpatialArgumentException(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, message);
    }

    public static InvalidSpatialArgumentException invalidDimension(String crs, int dimension, double ... coordinate) {
        return new InvalidSpatialArgumentException(String.format("Cannot create point, CRS %s expects %d dimensions, but got coordinates %s", crs, dimension, Arrays.toString(coordinate)));
    }

    public static InvalidSpatialArgumentException infiniteCoordinateValue(double ... coordinate) {
        return new InvalidSpatialArgumentException("Cannot create a point with non-finite coordinate values: " + Arrays.toString(coordinate));
    }

    public static InvalidSpatialArgumentException invalidGeographicCoordinates(double ... coordinate) {
        return new InvalidSpatialArgumentException("Cannot create WGS84 point with invalid coordinate: " + Arrays.toString(coordinate) + ". Valid range for Y coordinate is [-90, 90].");
    }

    public static InvalidSpatialArgumentException invalidCoordinateSystem(int crs) {
        return InvalidSpatialArgumentException.invalidCoordinateSystem("code=" + crs);
    }

    public static InvalidSpatialArgumentException invalidCoordinateSystem(String crs) {
        return new InvalidSpatialArgumentException("Unknown coordinate reference system: " + crs);
    }
}

