/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.admissioncontrol;

import java.time.Instant;
import org.neo4j.dbms.admissioncontrol.AdmissionControlResponse;
import org.neo4j.util.concurrent.BinaryLatch;

public final class AdmissionControlToken {
    public static final AdmissionControlToken ADMISSION_CONTROL_PROCESS_STOPPED = new AdmissionControlToken(AdmissionControlResponse.ADMISSION_CONTROL_PROCESS_STOPPED);
    public static final AdmissionControlToken UNABLE_TO_QUEUE_NEW_TOKEN = new AdmissionControlToken(AdmissionControlResponse.UNABLE_TO_ALLOCATE_NEW_TOKEN);
    public static final AdmissionControlToken RELEASED = new AdmissionControlToken(AdmissionControlResponse.RELEASED);
    private final BinaryLatch latch = new BinaryLatch();
    private final Instant queueTime;
    private volatile AdmissionControlResponse response;

    public AdmissionControlToken(Instant queueTime) {
        this.queueTime = queueTime;
    }

    private AdmissionControlToken(AdmissionControlResponse response) {
        this.latch.release();
        this.response = response;
        this.queueTime = null;
    }

    public Instant queueTime() {
        return this.queueTime;
    }

    public void release(AdmissionControlResponse response) {
        this.response = response;
        this.latch.release();
    }

    public AdmissionControlResponse await() {
        this.latch.await();
        return this.response;
    }
}

