/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.function.Supplier;
import org.neo4j.dbms.archive.ArchiveProgressPrinter;
import org.neo4j.dbms.archive.printer.OutputProgressPrinter;
import org.neo4j.dbms.archive.printer.ProgressPrinters;
import org.neo4j.graphdb.Resource;
import org.neo4j.io.ByteUnit;

class LoggingArchiveProgressPrinter
implements ArchiveProgressPrinter {
    public static final Duration PRINT_INTERVAL = Duration.ofSeconds(60L);
    private final OutputProgressPrinter progressPrinter;
    private final Supplier<Instant> timeSource;
    private long currentBytes;
    private long currentFiles;
    private boolean done;
    private long maxBytes;
    private long maxFiles;
    private boolean force;
    private Deadline deadline = null;
    private PercentageCondition percentage = null;

    public static ArchiveProgressPrinter createProgressPrinter(OutputProgressPrinter progressPrinter, Supplier<Instant> timeSource) {
        Objects.requireNonNull(progressPrinter);
        if (progressPrinter instanceof ProgressPrinters.EmptyOutputProgressPrinter) {
            return ArchiveProgressPrinter.EMPTY;
        }
        return new LoggingArchiveProgressPrinter(progressPrinter, timeSource);
    }

    private LoggingArchiveProgressPrinter(OutputProgressPrinter progressPrinter, Supplier<Instant> timeSource) {
        this.progressPrinter = Objects.requireNonNull(progressPrinter);
        this.timeSource = Objects.requireNonNull(timeSource);
    }

    @Override
    public Resource startPrinting() {
        this.deadline = new Deadline(Instant.EPOCH, PRINT_INTERVAL);
        return () -> {
            this.done();
            this.printProgress();
        };
    }

    @Override
    public void reset() {
        this.maxBytes = 0L;
        this.maxFiles = 0L;
        this.currentBytes = 0L;
        this.currentFiles = 0L;
        this.deadline = null;
        this.percentage = null;
    }

    @Override
    public void maxBytes(long value) {
        this.maxBytes = value;
        this.percentage = new PercentageCondition(value);
    }

    @Override
    public long maxBytes() {
        return this.maxBytes;
    }

    @Override
    public void maxFiles(long value) {
        this.maxFiles = value;
    }

    @Override
    public long maxFiles() {
        return this.maxFiles;
    }

    @Override
    public void beginFile() {
        ++this.currentFiles;
    }

    @Override
    public void printOnNextUpdate() {
        this.force = true;
    }

    @Override
    public void addBytes(long n) {
        boolean percentageReached;
        this.currentBytes += n;
        Instant when = this.timeSource.get();
        boolean deadlineReached = this.deadline != null && this.deadline.reached(when);
        boolean bl = percentageReached = this.percentage != null && this.percentage.updateAndCheckIfReached(this.currentBytes);
        if (this.force || deadlineReached || percentageReached) {
            this.printProgress();
            if (this.deadline != null) {
                this.deadline.next(when);
            }
            this.force = false;
        }
    }

    @Override
    public void endFile() {
        this.printProgress();
    }

    @Override
    public void done() {
        this.done = true;
    }

    @Override
    public void printProgress() {
        if (this.done) {
            this.progressPrinter.print("Done: " + this.currentFiles + " files, " + ByteUnit.bytesToString((long)this.currentBytes) + " processed.");
            this.progressPrinter.complete();
        } else if (this.maxFiles > 0L && this.maxBytes > 0L) {
            double progress = (double)this.currentBytes / (double)this.maxBytes * 100.0;
            this.progressPrinter.print("Files: " + this.currentFiles + "/" + this.maxFiles + ", data: " + String.format("%4.1f%%", progress));
        } else {
            this.progressPrinter.print("Files: " + this.currentFiles + "/?, data: ??.?%");
        }
    }

    static class Deadline {
        private final Duration interval;
        private Instant target;

        Deadline(Instant now, Duration interval) {
            this.interval = interval;
            this.target = Deadline.increment(now, interval);
        }

        boolean reached(Instant when) {
            return when.isAfter(this.target);
        }

        void next(Instant now) {
            this.target = Deadline.increment(now, this.interval);
        }

        private static Instant increment(Instant target, Duration duration) {
            return target.plusMillis(duration.toMillis());
        }
    }

    static class PercentageCondition {
        final long bucket;
        long current;

        PercentageCondition(long maxBytes) {
            this.bucket = maxBytes / 100L;
            this.current = 0L;
        }

        boolean updateAndCheckIfReached(long currentBytes) {
            if (this.bucket == 0L) {
                return false;
            }
            long previous = this.current;
            this.current = currentBytes / this.bucket;
            return this.current > previous;
        }
    }
}

