/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Optional;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.identity.ServerId;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.storageengine.api.ExternalStoreId;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.util.StoreIdDecodeUtils;

public record DatabaseDetails(Optional<ServerId> serverId, TopologyGraphDbmsModel.DatabaseAccess databaseAccess, Optional<SocketAddress> boltAddress, Optional<String> role, boolean writer, String status, String statusMessage, Optional<Long> lastCommittedTxId, Optional<Long> txCommitLag, NamedDatabaseId namedDatabaseId, String type, Optional<StoreId> storeId, Optional<ExternalStoreId> externalStoreId, int actualPrimariesCount, int actualSecondariesCount) {
    public static final String ROLE_PRIMARY = "primary";
    public static final String ROLE_SECONDARY = "secondary";
    public static final String STATUS_UNKNOWN = "unknown";
    public static final String STATUS_MESSAGE_UNKNOWN = "Server is unavailable";
    public static final String STATUS_MESSAGE_ORPHANED = "Database not currently allocated to any servers";
    public static final String TYPE_SYSTEM = "system";
    public static final String TYPE_STANDARD = "standard";
    public static final String TYPE_COMPOSITE = "composite";

    public String databaseType() {
        return this.type;
    }

    public Optional<String> readableExternalStoreId() {
        return this.externalStoreId.flatMap(id -> {
            try {
                return Optional.of(StoreIdDecodeUtils.decodeId((ExternalStoreId)id));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        });
    }

    public Optional<String> readableStoreId() {
        return this.storeId.map(StoreId::getStoreVersionUserString);
    }
}

