/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Objects;
import java.util.OptionalLong;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.database.DatabaseInfo;
import org.neo4j.dbms.database.TopologyGraphDbmsModel;
import org.neo4j.dbms.identity.ServerId;
import org.neo4j.kernel.database.NamedDatabaseId;

public class ExtendedDatabaseInfo
extends DatabaseInfo {
    public static final long COMMITTED_TX_ID_NOT_AVAILABLE = -1L;
    private final long lastCommittedTxId;
    private final long txCommitLag;
    private final boolean committedTxIdNotAvailable;

    public ExtendedDatabaseInfo(NamedDatabaseId namedDatabaseId, ServerId serverId, TopologyGraphDbmsModel.DatabaseAccess accessFromConfig, SocketAddress boltAddress, SocketAddress catchupAddress, String role, String status, String error, long lastCommittedTxId, long txCommitLag) {
        super(namedDatabaseId, serverId, accessFromConfig, boltAddress, catchupAddress, role, status, error);
        this.committedTxIdNotAvailable = lastCommittedTxId == -1L;
        this.lastCommittedTxId = this.committedTxIdNotAvailable ? 0L : lastCommittedTxId;
        this.txCommitLag = this.committedTxIdNotAvailable ? 0L : txCommitLag;
    }

    public OptionalLong lastCommittedTxId() {
        return this.committedTxIdNotAvailable ? OptionalLong.empty() : OptionalLong.of(this.lastCommittedTxId);
    }

    public OptionalLong txCommitLag() {
        return this.committedTxIdNotAvailable ? OptionalLong.empty() : OptionalLong.of(this.txCommitLag);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedDatabaseInfo that = (ExtendedDatabaseInfo)o;
        return this.lastCommittedTxId == that.lastCommittedTxId && this.txCommitLag == that.txCommitLag && Objects.equals(this.namedDatabaseId, that.namedDatabaseId) && Objects.equals(this.serverId, that.serverId) && Objects.equals(this.access, that.access) && Objects.equals(this.boltAddress, that.boltAddress) && Objects.equals(this.catchupAddress, that.catchupAddress) && Objects.equals(this.role, that.role) && Objects.equals(this.status, that.status) && Objects.equals(this.error, that.error);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.namedDatabaseId, this.serverId, this.access, this.boltAddress, this.catchupAddress, this.role, this.status, this.error, this.lastCommittedTxId, this.txCommitLag);
    }

    @Override
    public String toString() {
        return "ExtendedDatabaseInfoImpl{namedDatabaseId=" + this.namedDatabaseId + ", serverId=" + this.serverId + ", accessFromConfig=" + this.access + ", boltAddress=" + this.boltAddress + ", catchupAddress=" + this.catchupAddress + ", role='" + this.role + "', status='" + this.status + "', error='" + this.error + "', lastCommittedTxId=" + this.lastCommittedTxId() + ", txCommitLag=" + this.txCommitLag() + "}";
    }
}

