/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.util.Objects;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.memory.MemoryPools;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.time.Clocks;

public class StoreVersionLoader
implements AutoCloseable {
    private final FileSystemAbstraction fs;
    private final Config config;
    private final JobScheduler jobScheduler;
    private final PageCache pageCache;

    public StoreVersionLoader(FileSystemAbstraction fs, Config config) {
        this.fs = fs;
        this.config = Config.newBuilder().fromConfig(config).set(GraphDatabaseSettings.pagecache_memory, (Object)"8m").build();
        this.jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
        this.pageCache = new ConfiguringPageCacheFactory(fs, config, PageCacheTracer.NULL, (Log)NullLog.getInstance(), this.jobScheduler, Clocks.nanoClock(), new MemoryPools()).getOrCreatePageCache();
    }

    @Override
    public void close() {
        IOUtils.closeAllSilently((AutoCloseable[])new AutoCloseable[]{this.pageCache, this.jobScheduler});
    }

    public Result loadStoreVersion(DatabaseLayout layout) {
        StorageEngineFactory sef = StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)this.fs, (DatabaseLayout)layout, (PageCache)this.pageCache).orElseGet(StorageEngineFactory::defaultStorageEngine);
        StoreVersionCheck versionCheck = sef.versionCheck(this.fs, layout, this.config, this.pageCache, (LogService)NullLogService.getInstance(), PageCacheTracer.NULL);
        String storeVersion = (String)versionCheck.storeVersion(CursorContext.NULL).orElseThrow(() -> new IllegalStateException("Can not read store version of database " + layout.getDatabaseName()));
        return new Result(storeVersion, sef.versionInformation(storeVersion).latestStoreVersion());
    }

    public static class Result {
        public final String currentFormatName;
        public final String latestFormatName;
        public final boolean isLatest;

        private Result(String currentFormatName, String latestFormatName) {
            this.currentFormatName = currentFormatName;
            this.latestFormatName = latestFormatName;
            this.isLatest = Objects.equals(currentFormatName, latestFormatName);
        }
    }
}

