/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.text.StringEscapeUtils;
import org.jutils.jprocesses.JProcesses;
import org.jutils.jprocesses.model.ProcessInfo;
import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.ConfigUtils;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.diagnostics.jmx.JMXDumper;
import org.neo4j.dbms.diagnostics.jmx.JmxDump;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSource;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSources;
import org.neo4j.kernel.diagnostics.DiagnosticsReporter;
import org.neo4j.kernel.diagnostics.DiagnosticsReporterProgress;
import org.neo4j.kernel.diagnostics.InteractiveProgress;
import org.neo4j.kernel.diagnostics.NonInteractiveProgress;
import picocli.CommandLine;

@CommandLine.Command(name="report", header={"Produces a zip/tar of the most common information needed for remote assessments."}, description={"Will collect information about the system and package everything in an archive. If you specify 'all', everything will be included. You can also fine tune the selection by passing classifiers to the tool, e.g 'logs tx threads'."})
public class DiagnosticsReportCommand
extends AbstractCommand {
    static final String[] DEFAULT_CLASSIFIERS = new String[]{"logs", "config", "plugins", "tree", "metrics", "threads", "sysprop", "ps", "version"};
    private static final DateTimeFormatter filenameDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HHmmss");
    private static final long NO_PID = 0L;
    @CommandLine.Option(names={"--list"}, arity="0", description={"List all available classifiers"})
    private boolean list;
    @CommandLine.Option(names={"--force"}, arity="0", description={"Ignore disk full warning"})
    private boolean force;
    @CommandLine.Option(names={"--to"}, paramLabel="<path>", description={"Destination directory for reports. Defaults to a system tmp directory."})
    private Path reportDir;
    @CommandLine.Option(names={"--pid"}, description={"Specify process id of running neo4j instance"}, showDefaultValue=CommandLine.Help.Visibility.NEVER)
    private long pid;
    @CommandLine.Parameters(arity="0..*", paramLabel="<classifier>")
    private Set<String> classifiers = new TreeSet<String>(List.of(DEFAULT_CLASSIFIERS));
    private JMXDumper jmxDumper;

    public DiagnosticsReportCommand(ExecutionContext ctx) {
        super(ctx);
    }

    public void execute() {
        this.jmxDumper = new JMXDumper(this.ctx.homeDir(), this.ctx.fs(), this.ctx.out(), this.ctx.err(), this.verbose);
        DiagnosticsReporter reporter = this.createAndRegisterSources();
        if (this.list) {
            this.listClassifiers(reporter.getAvailableClassifiers());
            return;
        }
        this.validateClassifiers(reporter);
        DiagnosticsReporterProgress progress = this.buildProgress();
        try {
            if (this.reportDir == null) {
                this.reportDir = Path.of(System.getProperty("java.io.tmpdir"), new String[0]).resolve("reports").toAbsolutePath();
            }
            Path reportFile = this.reportDir.resolve(DiagnosticsReportCommand.getDefaultFilename());
            this.ctx.out().println("Writing report to " + reportFile.toAbsolutePath());
            reporter.dump(this.classifiers, reportFile, progress, this.force);
        }
        catch (IOException e) {
            throw new CommandFailedException("Creating archive failed", (Throwable)e);
        }
    }

    private static String getDefaultFilename() throws UnknownHostException {
        String hostName = InetAddress.getLocalHost().getHostName();
        String safeFilename = hostName.replaceAll("[^a-zA-Z0-9._]+", "_");
        return safeFilename + "-" + LocalDateTime.now().format(filenameDateTimeFormatter) + ".zip";
    }

    private DiagnosticsReporterProgress buildProgress() {
        return System.console() == null ? new NonInteractiveProgress(this.ctx.out(), this.verbose) : new InteractiveProgress(this.ctx.out(), this.verbose);
    }

    private void validateClassifiers(DiagnosticsReporter reporter) {
        Set availableClassifiers = reporter.getAvailableClassifiers();
        if (this.classifiers.contains("all")) {
            if (this.classifiers.size() != 1) {
                this.classifiers.remove("all");
                throw new CommandFailedException("If you specify 'all' this has to be the only classifier. Found ['" + String.join((CharSequence)"','", this.classifiers) + "'] as well.");
            }
        } else {
            if (this.classifiers.equals(Set.of(DEFAULT_CLASSIFIERS))) {
                this.classifiers = new HashSet<String>(this.classifiers);
                this.classifiers.retainAll(availableClassifiers);
            }
            DiagnosticsReportCommand.validateOrphanClassifiers(availableClassifiers, this.classifiers);
        }
    }

    private static void validateOrphanClassifiers(Set<String> availableClassifiers, Set<String> orphans) {
        for (String classifier : orphans) {
            if (availableClassifiers.contains(classifier)) continue;
            throw new CommandFailedException("Unknown classifier: " + classifier);
        }
    }

    private void listClassifiers(Set<String> availableClassifiers) {
        this.ctx.out().println("All available classifiers:");
        for (String classifier : availableClassifiers) {
            this.ctx.out().printf("  %-10s %s%n", classifier, DiagnosticsReportCommand.describeClassifier(classifier));
        }
    }

    private DiagnosticsReporter createAndRegisterSources() {
        DiagnosticsReporter reporter = new DiagnosticsReporter();
        Path configFile = this.ctx.confDir().resolve("neo4j.conf");
        Config config = this.getConfig(configFile);
        Path storeDirectory = (Path)config.get(GraphDatabaseInternalSettings.databases_root_path);
        reporter.registerAllOfflineProviders(config, storeDirectory, this.ctx.fs(), (String)config.get(GraphDatabaseSettings.default_database));
        reporter.registerSource("config", DiagnosticsReportSources.newDiagnosticsFile((String)"neo4j.conf", (FileSystemAbstraction)this.ctx.fs(), (Path)configFile));
        reporter.registerSource("ps", DiagnosticsReportCommand.runningProcesses());
        this.registerJMXSources(reporter);
        return reporter;
    }

    private void registerJMXSources(DiagnosticsReporter reporter) {
        Optional<JmxDump> jmxDump = this.pid == 0L ? this.jmxDumper.getJMXDump() : this.jmxDumper.getJMXDump(this.pid);
        jmxDump.ifPresent(jmx -> {
            reporter.registerSource("threads", jmx.threadDump());
            reporter.registerSource("heap", jmx.heapDump());
            reporter.registerSource("sysprop", jmx.systemProperties());
        });
    }

    private Config getConfig(Path configFile) {
        if (!this.ctx.fs().fileExists(configFile)) {
            throw new CommandFailedException("Unable to find config file, tried: " + configFile.toAbsolutePath());
        }
        Config cfg = Config.newBuilder().fromFileNoThrow(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.ctx.homeDir()).commandExpansion(this.allowCommandExpansion).build();
        ConfigUtils.disableAllConnectors((Config)cfg);
        return cfg;
    }

    static String describeClassifier(String classifier) {
        switch (classifier) {
            case "logs": {
                return "include log files";
            }
            case "config": {
                return "include configuration file";
            }
            case "plugins": {
                return "include a view of the plugin directory";
            }
            case "tree": {
                return "include a view of the tree structure of the data directory";
            }
            case "tx": {
                return "include transaction logs";
            }
            case "metrics": {
                return "include metrics";
            }
            case "threads": {
                return "include a thread dump of the running instance";
            }
            case "heap": {
                return "include a heap dump";
            }
            case "sysprop": {
                return "include a list of java system properties";
            }
            case "raft": {
                return "include the raft log";
            }
            case "ccstate": {
                return "include the current cluster state";
            }
            case "ps": {
                return "include a list of running processes";
            }
            case "version": {
                return "include version of neo4j";
            }
        }
        throw new IllegalArgumentException("Unknown classifier: " + classifier);
    }

    private static DiagnosticsReportSource runningProcesses() {
        return DiagnosticsReportSources.newDiagnosticsString((String)"ps.csv", () -> {
            List processesList = JProcesses.getProcessList();
            StringBuilder sb = new StringBuilder();
            sb.append(StringEscapeUtils.escapeCsv((String)"Process PID")).append(',').append(StringEscapeUtils.escapeCsv((String)"Process Name")).append(',').append(StringEscapeUtils.escapeCsv((String)"Process Time")).append(',').append(StringEscapeUtils.escapeCsv((String)"User")).append(',').append(StringEscapeUtils.escapeCsv((String)"Virtual Memory")).append(',').append(StringEscapeUtils.escapeCsv((String)"Physical Memory")).append(',').append(StringEscapeUtils.escapeCsv((String)"CPU usage")).append(',').append(StringEscapeUtils.escapeCsv((String)"Start Time")).append(',').append(StringEscapeUtils.escapeCsv((String)"Priority")).append(',').append(StringEscapeUtils.escapeCsv((String)"Full command")).append('\n');
            for (ProcessInfo processInfo : processesList) {
                sb.append(processInfo.getPid()).append(',').append(StringEscapeUtils.escapeCsv((String)processInfo.getName())).append(',').append(processInfo.getTime()).append(',').append(StringEscapeUtils.escapeCsv((String)processInfo.getUser())).append(',').append(processInfo.getVirtualMemory()).append(',').append(processInfo.getPhysicalMemory()).append(',').append(processInfo.getCpuUsage()).append(',').append(processInfo.getStartTime()).append(',').append(processInfo.getPriority()).append(',').append(StringEscapeUtils.escapeCsv((String)processInfo.getCommand())).append('\n');
            }
            return sb.toString();
        });
    }
}

