/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms.storeutil;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.collections.api.map.MutableMap;
import org.neo4j.commandline.dbms.storeutil.StoreCopyStats;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.NonUniqueTokenException;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.util.VisibleForTesting;

class RecreatingTokenHolder
implements TokenHolder {
    private final TokenHolder delegate;
    private final StoreCopyStats stats;
    private final MutableMap<String, List<NamedToken>> recreatedTokens;
    private final String tokenType;
    private int createdTokenCounter;

    RecreatingTokenHolder(String tokenType, StoreCopyStats stats, MutableMap<String, List<NamedToken>> recreatedTokens) {
        this.tokenType = tokenType;
        this.delegate = StoreTokens.createReadOnlyTokenHolder((String)tokenType);
        this.stats = stats;
        this.recreatedTokens = recreatedTokens;
    }

    public void setInitialTokens(List<NamedToken> tokens) throws NonUniqueTokenException {
        this.delegate.setInitialTokens(tokens);
    }

    public void addToken(NamedToken token) throws NonUniqueTokenException {
        throw new UnsupportedOperationException();
    }

    public int getOrCreateId(String name) {
        throw new UnsupportedOperationException();
    }

    public void getOrCreateIds(String[] names, int[] ids) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamedToken getTokenById(int id) {
        try {
            return this.delegate.getTokenById(id);
        }
        catch (TokenNotFoundException e) {
            RecreatingTokenHolder recreatingTokenHolder = this;
            synchronized (recreatingTokenHolder) {
                try {
                    return this.delegate.getTokenById(id);
                }
                catch (TokenNotFoundException ee) {
                    String tokenName;
                    this.stats.addCorruptToken(this.tokenType, id);
                    do {
                        ++this.createdTokenCounter;
                    } while (this.getIdByName(tokenName = this.generateRecreatedTokenName(this.createdTokenCounter)) != -1);
                    NamedToken token = new NamedToken(tokenName, id);
                    this.delegate.addToken(token);
                    ((List)this.recreatedTokens.getIfAbsentPut((Object)this.getTokenType(), ArrayList::new)).add(token);
                    return token;
                }
            }
        }
    }

    @VisibleForTesting
    String generateRecreatedTokenName(int number) {
        return this.getTokenType() + "_" + number;
    }

    public int getIdByName(String name) {
        return this.delegate.getIdByName(name);
    }

    public boolean getIdsByNames(String[] names, int[] ids) {
        return this.delegate.getIdsByNames(names, ids);
    }

    public Iterable<NamedToken> getAllTokens() {
        return this.delegate.getAllTokens();
    }

    public String getTokenType() {
        return this.delegate.getTokenType();
    }

    public boolean hasToken(int id) {
        return this.delegate.hasToken(id);
    }

    public int size() {
        return this.delegate.size();
    }

    public void getOrCreateInternalIds(String[] names, int[] ids) {
        throw new UnsupportedOperationException();
    }

    public NamedToken getInternalTokenById(int id) throws TokenNotFoundException {
        return this.delegate.getInternalTokenById(id);
    }
}

