/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms.storeutil;

import java.io.IOException;
import org.neo4j.commandline.dbms.storeutil.StoreCopyFilter;
import org.neo4j.commandline.dbms.storeutil.StoreCopyStats;
import org.neo4j.internal.batchimport.input.InputChunk;
import org.neo4j.internal.batchimport.input.InputEntityVisitor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.values.storable.Value;

public abstract class LenientStoreInputChunk
implements InputChunk {
    private final PropertyStore propertyStore;
    private long id;
    private long endId;
    protected final StoreCopyStats stats;
    protected final TokenHolders tokenHolders;
    protected final PageCursor cursor;
    final StoreCopyFilter storeCopyFilter;

    LenientStoreInputChunk(StoreCopyStats stats, PropertyStore propertyStore, TokenHolders tokenHolders, PageCursor cursor, StoreCopyFilter storeCopyFilter) {
        this.stats = stats;
        this.propertyStore = propertyStore;
        this.tokenHolders = tokenHolders;
        this.cursor = cursor;
        this.storeCopyFilter = storeCopyFilter;
    }

    void setChunkRange(long startId, long endId) {
        this.id = startId;
        this.endId = endId;
    }

    public boolean next(InputEntityVisitor visitor) {
        if (this.id < this.endId) {
            this.stats.count.increment();
            try {
                this.readAndVisit(this.id, visitor);
            }
            catch (Exception e) {
                if (e instanceof InvalidRecordException && e.getMessage().endsWith("not in use")) {
                    this.stats.unused.increment();
                }
                this.stats.removed.increment();
                this.stats.brokenRecord(this.recordType(), this.id, e);
            }
            ++this.id;
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        this.cursor.close();
    }

    abstract void readAndVisit(long var1, InputEntityVisitor var3) throws IOException;

    abstract String recordType();

    void visitPropertyChainNoThrow(InputEntityVisitor visitor, PrimitiveRecord record) {
        try {
            if (record.getNextProp() == (long)Record.NO_NEXT_PROPERTY.intValue()) {
                return;
            }
            long nextProp = record.getNextProp();
            while (!Record.NO_NEXT_PROPERTY.is(nextProp)) {
                PropertyRecord propertyRecord = (PropertyRecord)this.propertyStore.getRecord(nextProp, (AbstractBaseRecord)this.propertyStore.newRecord(), RecordLoad.NORMAL);
                for (PropertyBlock propBlock : propertyRecord) {
                    this.propertyStore.ensureHeavy(propBlock);
                    if (!this.storeCopyFilter.shouldKeepProperty(propBlock.getKeyIndexId())) continue;
                    try {
                        String key = this.tokenHolders.propertyKeyTokens().getTokenById(propBlock.getKeyIndexId()).name();
                        Value propertyValue = propBlock.newPropertyValue(this.propertyStore);
                        visitor.property(key, propertyValue.asObject());
                    }
                    catch (TokenNotFoundException ignored) {
                        this.stats.brokenPropertyToken(this.recordType(), record, propBlock.newPropertyValue(this.propertyStore), propBlock.getKeyIndexId());
                    }
                }
                nextProp = propertyRecord.getNextProp();
            }
        }
        catch (Exception e) {
            this.stats.brokenPropertyChain(this.recordType(), record, e);
        }
    }
}

