/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.nio.file.Path;
import javax.annotation.Nonnull;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.AdminCommandSection;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.dbms.MemoryRecommendationsCommand;

public class MemoryRecommendationsCommandProvider
extends AdminCommand.Provider {
    public MemoryRecommendationsCommandProvider() {
        super("memrec", new String[0]);
    }

    @Nonnull
    public Arguments allArguments() {
        return MemoryRecommendationsCommand.buildArgs();
    }

    @Nonnull
    public String summary() {
        return "Print Neo4j heap and pagecache memory settings recommendations.";
    }

    @Nonnull
    public AdminCommandSection commandSection() {
        return AdminCommandSection.general();
    }

    @Nonnull
    public String description() {
        return String.format("Print heuristic memory setting recommendations for the Neo4j JVM heap and pagecache. The heuristic is based on the total memory of the system the command is running on, or on the amount of memory specified with the --memory argument. The heuristic assumes that the system is dedicated to running Neo4j. If this is not the case, then use the --memory argument to specify how much memory can be expected to be dedicated to Neo4j.%n%nThe output is formatted such that it can be copy-posted into the neo4j.conf file.", new Object[0]);
    }

    @Nonnull
    public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        return new MemoryRecommendationsCommand(outsideWorld);
    }
}

