/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.arguments.NamedArgument;
import org.neo4j.commandline.arguments.common.MandatoryCanonicalPath;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.kernel.internal.Version;

public class VersionCommand
implements AdminCommand {
    private static final Arguments arguments = new Arguments().withArgument((NamedArgument)new MandatoryCanonicalPath("store", "path-to-dir", "Path to database store to check version of."));
    private Consumer<String> out;

    public VersionCommand(Consumer<String> out) {
        this.out = out;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        Path storeDir = arguments.parseMandatoryPath("store", args);
        Validators.CONTAINS_EXISTING_DATABASE.validate((Object)storeDir.toFile());
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
             PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fileSystem);){
            String storeVersion = (String)new StoreVersionCheck(pageCache).getVersion(storeDir.resolve("neostore").toFile()).orElseThrow(() -> new CommandFailed(String.format("Could not find version metadata in store '%s'", storeDir)));
            String fmt = "%-25s%s";
            this.out.accept(String.format("%-25s%s", "Store format version:", storeVersion));
            RecordFormats format = RecordFormatSelector.selectForVersion((String)storeVersion);
            this.out.accept(String.format("%-25s%s", "Introduced in version:", format.introductionVersion()));
            RecordFormatSelector.findSuccessor((RecordFormats)format).map(next -> String.format("%-25s%s", "Superseded in version:", next.introductionVersion())).ifPresent(this.out);
            this.out.accept(String.format("%-25s%s", "Current version:", Version.getNeo4jVersion()));
        }
        catch (IOException e) {
            throw new CommandFailed(e.getMessage(), (Exception)e);
        }
    }

    public static class Provider
    extends AdminCommand.Provider {
        public Provider() {
            super("version", new String[0]);
        }

        public Arguments allArguments() {
            return arguments;
        }

        public String summary() {
            return "Check the version of a Neo4j database store.";
        }

        public String description() {
            return "Checks the version of a Neo4j database store. Note that this command expects a path to a store directory, for example --store=data/databases/graph.db.";
        }

        public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
            return new VersionCommand(arg_0 -> ((OutsideWorld)outsideWorld).stdOutLine(arg_0));
        }
    }
}

