/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.commandline.Util;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.arguments.NamedArgument;
import org.neo4j.commandline.arguments.OptionalBooleanArg;
import org.neo4j.commandline.arguments.common.MandatoryCanonicalPath;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.dbms.archive.IncorrectFormat;
import org.neo4j.dbms.archive.Loader;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.server.configuration.ConfigLoader;

public class LoadCommand
implements AdminCommand {
    private static final Arguments arguments = new Arguments().withArgument((NamedArgument)new MandatoryCanonicalPath("from", "archive-path", "Path to archive created with the dump command.")).withDatabase().withArgument((NamedArgument)new OptionalBooleanArg("force", false, "If an existing database should be replaced."));
    private final Path homeDir;
    private final Path configDir;
    private final Loader loader;

    public LoadCommand(Path homeDir, Path configDir, Loader loader) {
        Objects.requireNonNull(homeDir);
        Objects.requireNonNull(configDir);
        Objects.requireNonNull(loader);
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.loader = loader;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        Path archive = arguments.parseMandatoryPath("from", args);
        String database = arguments.parse("database", args);
        boolean force = arguments.parseBoolean("force", args);
        Path databaseDirectory = Util.canonicalPath((Path)this.toDatabaseDirectory(database));
        this.deleteIfNecessary(databaseDirectory, force);
        this.load(archive, database, databaseDirectory);
    }

    private Path toDatabaseDirectory(String databaseName) {
        return ((File)new ConfigLoader(Arrays.asList(DatabaseManagementSystemSettings.class, GraphDatabaseSettings.class)).loadOfflineConfig(Optional.of(this.homeDir.toFile()), Optional.of(this.configDir.resolve("neo4j.conf").toFile())).with(MapUtil.stringMap((String[])new String[]{DatabaseManagementSystemSettings.active_database.name(), databaseName}), new Class[0]).get(DatabaseManagementSystemSettings.database_path)).toPath();
    }

    private void deleteIfNecessary(Path databaseDirectory, boolean force) throws CommandFailed {
        try {
            if (force) {
                Util.checkLock((Path)databaseDirectory);
                FileUtils.deletePathRecursively((Path)databaseDirectory);
            }
        }
        catch (IOException e) {
            Util.wrapIOException((IOException)e);
        }
    }

    private void load(Path archive, String database, Path databaseDirectory) throws CommandFailed {
        try {
            this.loader.load(archive, databaseDirectory);
        }
        catch (NoSuchFileException e) {
            if (Paths.get(e.getMessage(), new String[0]).toAbsolutePath().equals(archive.toAbsolutePath())) {
                throw new CommandFailed("archive does not exist: " + archive, (Exception)e);
            }
            Util.wrapIOException((IOException)e);
        }
        catch (FileAlreadyExistsException e) {
            throw new CommandFailed("database already exists: " + database, (Exception)e);
        }
        catch (AccessDeniedException e) {
            throw new CommandFailed("you do not have permission to load a database -- is Neo4j running as a different user?", (Exception)e);
        }
        catch (IOException e) {
            Util.wrapIOException((IOException)e);
        }
        catch (IncorrectFormat incorrectFormat) {
            throw new CommandFailed("Not a valid Neo4j archive: " + archive, (Exception)incorrectFormat);
        }
    }

    public static Arguments arguments() {
        return arguments;
    }
}

