/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.internal.StoreLocker;

public class Util {
    public static void checkLock(Path databaseDirectory) throws CommandFailed {
        try {
            StoreLocker storeLocker = new StoreLocker((FileSystemAbstraction)new DefaultFileSystemAbstraction());
            storeLocker.checkLock(databaseDirectory.toFile());
            storeLocker.release();
        }
        catch (StoreLockException e) {
            throw new CommandFailed("the database is in use -- stop Neo4j and try again", (Exception)((Object)e));
        }
        catch (IOException e) {
            Util.wrapIOException(e);
        }
    }

    public static void wrapIOException(IOException e) throws CommandFailed {
        throw new CommandFailed(String.format("unable to load database: %s: %s", e.getClass().getSimpleName(), e.getMessage()), (Exception)e);
    }
}

