/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.dbms.Util;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.dbms.archive.IncorrectFormat;
import org.neo4j.dbms.archive.Loader;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.server.configuration.ConfigLoader;

public class LoadCommand
implements AdminCommand {
    private final Path homeDir;
    private final Path configDir;
    private final Loader loader;

    public LoadCommand(Path homeDir, Path configDir, Loader loader) {
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.loader = loader;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        Path archive = this.parse(args, "from", x$0 -> Paths.get(x$0, new String[0]));
        String database = (String)this.parse(args, "database", Converters.identity());
        boolean force = Args.parse((String[])args).getBoolean("force");
        Path databaseDirectory = this.toDatabaseDirectory(database);
        this.deleteIfNecessary(databaseDirectory, force);
        this.load(archive, database, databaseDirectory);
    }

    private <T> T parse(String[] args, String argument, Function<String, T> converter) throws IncorrectUsage {
        try {
            return (T)Args.parse((String[])args).interpretOption(argument, Converters.mandatory(), converter, new Validator[0]);
        }
        catch (IllegalArgumentException e) {
            throw new IncorrectUsage(e.getMessage());
        }
    }

    private Path toDatabaseDirectory(String databaseName) {
        return ((File)new ConfigLoader(Arrays.asList(DatabaseManagementSystemSettings.class, GraphDatabaseSettings.class)).loadOfflineConfig(Optional.of(this.homeDir.toFile()), Optional.of(this.configDir.resolve("neo4j.conf").toFile())).with(MapUtil.stringMap((String[])new String[]{DatabaseManagementSystemSettings.active_database.name(), databaseName}), new Class[0]).get(DatabaseManagementSystemSettings.database_path)).toPath();
    }

    private void deleteIfNecessary(Path databaseDirectory, boolean force) throws CommandFailed {
        try {
            if (force) {
                Util.checkLock(databaseDirectory);
                FileUtils.deletePathRecursively((Path)databaseDirectory);
            }
        }
        catch (IOException e) {
            Util.wrapIOException(e);
        }
    }

    private void load(Path archive, String database, Path databaseDirectory) throws CommandFailed {
        try {
            this.loader.load(archive, databaseDirectory);
        }
        catch (NoSuchFileException e) {
            if (Paths.get(e.getMessage(), new String[0]).toAbsolutePath().equals(archive.toAbsolutePath())) {
                throw new CommandFailed("archive does not exist: " + archive, (Exception)e);
            }
            Util.wrapIOException(e);
        }
        catch (FileAlreadyExistsException e) {
            throw new CommandFailed("database already exists: " + database, (Exception)e);
        }
        catch (AccessDeniedException e) {
            throw new CommandFailed("you do not have permission to load a database -- is Neo4j running as a different user?", (Exception)e);
        }
        catch (IOException e) {
            Util.wrapIOException(e);
        }
        catch (IncorrectFormat incorrectFormat) {
            throw new CommandFailed("Not a valid Neo4j archive: " + archive, (Exception)incorrectFormat);
        }
    }

    public static class Provider
    extends AdminCommand.Provider {
        public Provider() {
            super("load", new String[0]);
        }

        public Optional<String> arguments() {
            return Optional.of("--from=<archive-path> --database=<database> [--force]");
        }

        public String description() {
            return "Load a database from an archive. <archive-path> must be an archive created with the dump command. <database> is the name of the database to create. Existing databases can be replaced by specifying --force. It is not possible to replace a database that is mounted in a running Neo4j server.";
        }

        public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
            return new LoadCommand(homeDir, configDir, new Loader());
        }
    }
}

