/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Collection;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.dbms.Importer;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.helpers.Args;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.tooling.ImportTool;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Collectors;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.csv.CsvInput;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;

class CsvImporter
implements Importer {
    private final Collection<Args.Option<File[]>> nodesFiles;
    private final Collection<Args.Option<File[]>> relationshipsFiles;
    private final IdType idType;
    private final Charset inputEncoding;
    private final int pageSize;
    private final Config config;
    private final Args args;
    private final OutsideWorld outsideWorld;

    public static String description() {
        return "--mode=csv Import a database from a collection of CSV files.\n--nodes[:Label1:Label2]=\"<file1>,<file2>,...\"\n        Node CSV header and data. Multiple files will be logically seen as\n        one big file from the perspective of the importer. The first line\n        must contain the header. Multiple data sources like these can be\n        specified in one import, where each data source has its own header.\n        Note that file groups must be enclosed in quotation marks.\n--relationships[:RELATIONSHIP_TYPE] \"<file1>,<file2>,...\"\n        Relationship CSV header and data. Multiple files will be logically\n        seen as one big file from the perspective of the importer. The first\n        line must contain the header. Multiple data sources like these can be\n        specified in one import, where each data source has its own header.\n        Note that file groups must be enclosed in quotation marks.\n--id-type <id-type>\n        Each node must provide a unique id. This is used to find the correct\n        nodes when creating relationships. Must be one of:\n            STRING: (default) arbitrary strings for identifying nodes.\n            INTEGER: arbitrary integer values for identifying nodes.\n            ACTUAL: (advanced) actual node ids. The default option is STRING.\n        For more information on id handling, please see the Neo4j Manual:\n        http://neo4j.com/docs/operations-manual/current/deployment/#import-tool\n--input-encoding <character-set>\n        Character set that input data is encoded in. Defaults to UTF-8.\n--page-size <page-size>\n        Page size to use for import in bytes. (e. g. 4M or 8k)\n";
    }

    public static String arguments() {
        return "[--nodes[:Label1:Label2]=\"<file1>,<file2>,...\"] [--relationships[:RELATIONSHIP_TYPE]=\"<file1>,<file2>,...\"] [--input-encoding=<character-set>] [--id-type=<id-type>] ";
    }

    CsvImporter(Args args, Config config, OutsideWorld outsideWorld) throws IncorrectUsage {
        this.args = args;
        this.outsideWorld = outsideWorld;
        this.nodesFiles = ImportTool.extractInputFiles((Args)args, (String)"nodes", (PrintStream)outsideWorld.errorStream());
        this.relationshipsFiles = ImportTool.extractInputFiles((Args)args, (String)"relationships", (PrintStream)outsideWorld.errorStream());
        try {
            ImportTool.validateInputFiles(this.nodesFiles, this.relationshipsFiles);
        }
        catch (IllegalArgumentException e) {
            throw new IncorrectUsage(e.getMessage());
        }
        this.idType = (IdType)args.interpretOption("id-type", Converters.withDefault((Object)IdType.STRING), from -> IdType.valueOf((String)from.toUpperCase()), new Validator[0]);
        this.inputEncoding = Charset.forName(args.get("input-encoding", Charset.defaultCharset().name()));
        this.pageSize = Math.toIntExact(Settings.parseLongWithUnit((String)args.get("page-size", String.valueOf(Configuration.DEFAULT.pageSize()))));
        this.config = config;
    }

    @Override
    public void doImport() throws IOException {
        PrintStream badOutput = this.outsideWorld.errorStream();
        Collector badCollector = Collectors.badCollector((OutputStream)badOutput, (int)1000, (int)Collectors.collect((boolean)true, (boolean)false, (boolean)false));
        Configuration configuration = ImportTool.importConfiguration(null, (boolean)false, (Config)this.config, (int)this.pageSize);
        CsvInput input = new CsvInput(ImportTool.nodeData((Charset)this.inputEncoding, this.nodesFiles), DataFactories.defaultFormatNodeFileHeader(), ImportTool.relationshipData((Charset)this.inputEncoding, this.relationshipsFiles), DataFactories.defaultFormatRelationshipFileHeader(), this.idType, ImportTool.csvConfiguration((Args)this.args, (boolean)false), badCollector, configuration.maxNumberOfProcessors());
        ImportTool.doImport((PrintStream)this.outsideWorld.errorStream(), (PrintStream)this.outsideWorld.errorStream(), (File)((File)this.config.get(DatabaseManagementSystemSettings.database_path)), this.nodesFiles, this.relationshipsFiles, (boolean)false, (Input)input, (Config)this.config, (OutputStream)badOutput, (Configuration)configuration);
    }
}

