/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.util.Map;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;

abstract class CollectorStateMachine<DATA> {
    private State state;
    private long collectionId;
    private final boolean canGetDataWhileCollecting;

    static Result success(String message) {
        return new Result(true, message);
    }

    static Result error(String message) {
        return new Result(false, message);
    }

    CollectorStateMachine(boolean canGetDataWhileCollecting) {
        this.canGetDataWhileCollecting = canGetDataWhileCollecting;
        this.state = State.IDLE;
    }

    public synchronized Status status() {
        return switch (this.state) {
            default -> throw new IncompatibleClassChangeError();
            case State.IDLE -> new Status("idle");
            case State.COLLECTING -> new Status("collecting");
        };
    }

    public synchronized Result collect(Map<String, Object> config) throws InvalidArgumentsException {
        return switch (this.state) {
            default -> throw new IncompatibleClassChangeError();
            case State.IDLE -> {
                this.state = State.COLLECTING;
                ++this.collectionId;
                yield this.doCollect(config, this.collectionId);
            }
            case State.COLLECTING -> CollectorStateMachine.success("Collection is already ongoing.");
        };
    }

    public synchronized Result stop(long collectionIdToStop) {
        return switch (this.state) {
            default -> throw new IncompatibleClassChangeError();
            case State.IDLE -> CollectorStateMachine.success("Collector is idle, no collection ongoing.");
            case State.COLLECTING -> {
                if (this.collectionId <= collectionIdToStop) {
                    this.state = State.IDLE;
                    yield this.doStop();
                }
                yield CollectorStateMachine.success(String.format("Collection event %d has already been stopped, a new collection event is ongoing.", collectionIdToStop));
            }
        };
    }

    public synchronized Result clear() {
        return switch (this.state) {
            default -> throw new IncompatibleClassChangeError();
            case State.IDLE -> this.doClear();
            case State.COLLECTING -> CollectorStateMachine.error("Collected data cannot be cleared while collecting.");
        };
    }

    public synchronized DATA getData() {
        return switch (this.state) {
            default -> throw new IncompatibleClassChangeError();
            case State.IDLE -> this.doGetData();
            case State.COLLECTING -> {
                if (this.canGetDataWhileCollecting) {
                    yield this.doGetData();
                }
                throw new IllegalStateException("Collector is still collecting.");
            }
        };
    }

    protected abstract Result doCollect(Map<String, Object> var1, long var2) throws InvalidArgumentsException;

    protected abstract Result doStop();

    protected abstract Result doClear();

    protected abstract DATA doGetData();

    record Result(boolean success, String message) {
    }

    private static enum State {
        IDLE,
        COLLECTING;

    }

    record Status(String message) {
    }
}

