/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.nio.ByteOrder;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.stream.Stream;
import org.neo4j.internal.collector.RetrieveResult;
import org.neo4j.internal.collector.TokensSection;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.io.os.OsBeanUtil;
import org.neo4j.kernel.api.Kernel;

final class MetaSection {
    private MetaSection() {
    }

    static Stream<RetrieveResult> retrieve(String graphToken, Kernel kernel, long numSilentQueryDrops) throws TransactionFailureException {
        HashMap<String, Object> systemData = new HashMap<String, Object>();
        systemData.put("jvmMemoryFree", Runtime.getRuntime().freeMemory());
        systemData.put("jvmMemoryTotal", Runtime.getRuntime().totalMemory());
        systemData.put("jvmMemoryMax", Runtime.getRuntime().maxMemory());
        systemData.put("systemTotalPhysicalMemory", OsBeanUtil.getTotalPhysicalMemory());
        systemData.put("systemFreePhysicalMemory", OsBeanUtil.getFreePhysicalMemory());
        systemData.put("systemCommittedVirtualMemory", OsBeanUtil.getCommittedVirtualMemory());
        systemData.put("systemTotalSwapSpace", OsBeanUtil.getTotalSwapSpace());
        systemData.put("systemFreeSwapSpace", OsBeanUtil.getFreeSwapSpace());
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        systemData.put("osArch", os.getArch());
        systemData.put("osName", os.getName());
        systemData.put("osVersion", os.getVersion());
        systemData.put("availableProcessors", os.getAvailableProcessors());
        systemData.put("byteOrder", ByteOrder.nativeOrder().toString());
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        systemData.put("jvmName", runtime.getVmName());
        systemData.put("jvmVendor", runtime.getVmVendor());
        systemData.put("jvmVersion", runtime.getVmVersion());
        CompilationMXBean compiler = ManagementFactory.getCompilationMXBean();
        systemData.put("jvmJITCompiler", compiler == null ? "unknown" : compiler.getName());
        systemData.put("userLanguage", Locale.getDefault().getLanguage());
        systemData.put("userCountry", Locale.getDefault().getCountry());
        systemData.put("userTimezone", TimeZone.getDefault().getID());
        systemData.put("fileEncoding", System.getProperty("file.encoding"));
        HashMap<String, Long> internalData = new HashMap<String, Long>();
        internalData.put("numSilentQueryCollectionMisses", numSilentQueryDrops);
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.put("graphToken", graphToken);
        metaData.put("retrieveTime", ZonedDateTime.now());
        metaData.put("system", systemData);
        metaData.put("internal", internalData);
        TokensSection.putTokenCounts(metaData, kernel);
        return Stream.of(new RetrieveResult("META", metaData));
    }
}

