/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.neo4j.internal.collector.RecentBuffer;
import org.neo4j.util.Preconditions;

public class RingRecentBuffer<T>
implements RecentBuffer<T> {
    private final int size;
    private final int mask;
    private final VolatileRef<T>[] data;
    private final AtomicLong produceCount;
    private final AtomicLong consumeCount;
    private final AtomicLong dropEvents;

    public RingRecentBuffer(int size) {
        if (size > 0) {
            Preconditions.requirePowerOfTwo((long)size);
        }
        this.size = size;
        this.mask = size - 1;
        this.data = new VolatileRef[size];
        for (int i = 0; i < size; ++i) {
            this.data[i] = new VolatileRef();
            this.data[i].produceNumber = i - size;
        }
        this.produceCount = new AtomicLong(0L);
        this.consumeCount = new AtomicLong(0L);
        this.dropEvents = new AtomicLong(0L);
    }

    long numSilentQueryDrops() {
        return this.dropEvents.get();
    }

    @Override
    public void produce(T t) {
        int offset;
        VolatileRef<T> volatileRef;
        if (this.size == 0) {
            return;
        }
        long produceNumber = this.produceCount.getAndIncrement();
        if (this.assertPreviousCompleted(produceNumber, volatileRef = this.data[offset = (int)(produceNumber & (long)this.mask)])) {
            volatileRef.ref = t;
            volatileRef.produceNumber = produceNumber;
        } else {
            this.dropEvents.incrementAndGet();
        }
    }

    private boolean assertPreviousCompleted(long produceNumber, VolatileRef<T> volatileRef) {
        int attempts;
        long prevProduceNumber = volatileRef.produceNumber;
        for (attempts = 100; prevProduceNumber != produceNumber - (long)this.size && attempts > 0; --attempts) {
            try {
                Thread.sleep(0L, 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            prevProduceNumber = volatileRef.produceNumber;
        }
        return attempts > 0;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        for (VolatileRef<T> volatileRef : this.data) {
            volatileRef.ref = null;
        }
        long snapshotProduce = this.produceCount.get();
        this.consumeCount.set(snapshotProduce);
    }

    @Override
    public void foreach(Consumer<T> consumer) {
        long snapshotConsume;
        if (this.size == 0) {
            return;
        }
        long snapshotProduce = this.produceCount.get();
        for (long i = snapshotConsume = Math.max(this.consumeCount.get(), snapshotProduce - (long)this.size); i < snapshotProduce; ++i) {
            int offset = (int)(i & (long)this.mask);
            VolatileRef<T> volatileRef = this.data[offset];
            if (volatileRef.produceNumber < i) {
                return;
            }
            consumer.accept(volatileRef.ref);
        }
    }

    private static class VolatileRef<T> {
        private volatile T ref;
        private volatile long produceNumber;

        private VolatileRef() {
        }
    }
}

