/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.internal.collector.CollectorStateMachine;
import org.neo4j.internal.collector.QueryCollectorConfig;
import org.neo4j.internal.collector.RingRecentBuffer;
import org.neo4j.internal.collector.TruncatedQuerySnapshot;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;

class QueryCollector
extends CollectorStateMachine<Iterator<TruncatedQuerySnapshot>>
implements QueryExecutionMonitor {
    private volatile boolean isCollecting;
    private final RingRecentBuffer<TruncatedQuerySnapshot> queries;
    private final JobScheduler jobScheduler;
    private final int maxQueryTextSize;

    QueryCollector(JobScheduler jobScheduler, int maxRecentQueryCount, int maxQueryTextSize) {
        super(true);
        this.jobScheduler = jobScheduler;
        this.maxQueryTextSize = maxQueryTextSize;
        this.isCollecting = false;
        int queryBufferSize = Integer.highestOneBit(maxRecentQueryCount);
        this.queries = new RingRecentBuffer(queryBufferSize);
    }

    long numSilentQueryDrops() {
        return this.queries.numSilentQueryDrops();
    }

    @Override
    protected CollectorStateMachine.Result doCollect(Map<String, Object> config, long collectionId) throws InvalidArgumentsException {
        int collectSeconds = QueryCollectorConfig.of(config).collectSeconds;
        if (collectSeconds > 0) {
            this.jobScheduler.schedule(Group.DATA_COLLECTOR, () -> this.stop(collectionId), (long)collectSeconds, TimeUnit.SECONDS);
        }
        this.isCollecting = true;
        return QueryCollector.success("Collection started.");
    }

    @Override
    protected CollectorStateMachine.Result doStop() {
        this.isCollecting = false;
        return QueryCollector.success("Collection stopped.");
    }

    @Override
    protected CollectorStateMachine.Result doClear() {
        this.queries.clear();
        return QueryCollector.success("Data cleared.");
    }

    @Override
    protected Iterator<TruncatedQuerySnapshot> doGetData() {
        ArrayList querySnapshots = new ArrayList();
        this.queries.foreach(querySnapshots::add);
        return querySnapshots.iterator();
    }

    public void endFailure(ExecutingQuery query, Throwable failure) {
    }

    public void endFailure(ExecutingQuery query, String reason) {
    }

    public void endSuccess(ExecutingQuery query) {
        if (this.isCollecting) {
            QuerySnapshot snapshot = query.snapshot();
            this.queries.produce(new TruncatedQuerySnapshot(snapshot.queryText(), snapshot.queryPlanSupplier(), snapshot.queryParameters(), snapshot.elapsedTimeMicros(), snapshot.compilationTimeMicros(), snapshot.startTimestampMillis(), this.maxQueryTextSize));
        }
    }
}

