/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.util.function.Function;
import org.neo4j.cypher.internal.CypherQueryObfuscator$;
import org.neo4j.cypher.internal.util.LiteralOffset;
import org.neo4j.cypher.internal.util.ObfuscationMetadata;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.kernel.api.query.QueryObfuscator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\rb\u0001\u0002\t\u0012\u0001iA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\u0006i\u0001!\t!\u000e\u0005\u0006s\u0001!\tE\u000f\u0005\u0006!\u0002!\t%\u0015\u0005\u00069\u0002!I!\u0018\u0005\u0006C\u0002!\tE\u0019\u0005\u0006g\u0002!I\u0001^\u0004\u0006qFA\t!\u001f\u0004\u0006!EA\tA\u001f\u0005\u0006i%!\tA \u0005\t\u007f&\u0011\r\u0011\"\u0003\u0002\u0002!A\u0011qA\u0005!\u0002\u0013\t\u0019\u0001C\u0005\u0002\n%\u0011\r\u0011\"\u0003\u0002\f!A\u0011\u0011D\u0005!\u0002\u0013\ti\u0001C\u0004\u0002\u001c%!\t!!\b\u0003+\rK\b\u000f[3s#V,'/_(cMV\u001c8-\u0019;pe*\u0011!cE\u0001\tS:$XM\u001d8bY*\u0011A#F\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005Y9\u0012!\u00028f_RR'\"\u0001\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Y2\u0005\u0005\u0002\u001dC5\tQD\u0003\u0002\u001f?\u0005!A.\u00198h\u0015\u0005\u0001\u0013\u0001\u00026bm\u0006L!AI\u000f\u0003\r=\u0013'.Z2u!\t!3&D\u0001&\u0015\t1s%A\u0003rk\u0016\u0014\u0018P\u0003\u0002)S\u0005\u0019\u0011\r]5\u000b\u0005)*\u0012AB6fe:,G.\u0003\u0002-K\ty\u0011+^3ss>\u0013g-^:dCR|'/A\u0003ti\u0006$X\r\u0005\u00020e5\t\u0001G\u0003\u00022#\u0005!Q\u000f^5m\u0013\t\u0019\u0004GA\nPE\u001a,8oY1uS>tW*\u001a;bI\u0006$\u0018-\u0001\u0004=S:LGO\u0010\u000b\u0003ma\u0002\"a\u000e\u0001\u000e\u0003EAQ!\f\u0002A\u00029\nQb\u001c2gkN\u001c\u0017\r^3UKb$HcA\u001eI\u0015B\u0011A(\u0012\b\u0003{\r\u0003\"AP!\u000e\u0003}R!\u0001Q\r\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0003\u0019\u0001&/\u001a3fM&\u0011ai\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0011\u000b\u0005\"B%\u0004\u0001\u0004Y\u0014\u0001\u0004:boF+XM]=UKb$\b\"B&\u0004\u0001\u0004a\u0015a\u00049sKB\u000b'o]3s\u001f\u001a47/\u001a;\u0011\u00055sU\"A!\n\u0005=\u000b%aA%oi\u0006\u0019rN\u00194vg\u000e\fG/\u001a)be\u0006lW\r^3sgR\u0011!K\u0017\t\u0003'bk\u0011\u0001\u0016\u0006\u0003+Z\u000bqA^5siV\fGN\u0003\u0002X+\u00051a/\u00197vKNL!!\u0017+\u0003\u00115\u000b\u0007OV1mk\u0016DQa\u0017\u0003A\u0002I\u000b!C]1x#V,'/\u001f)be\u0006lW\r^3sg\u0006\u0019B.\u001b;fe\u0006d7\u000b\u001e:j]\u001edUM\\4uQR\u0019AJX0\t\u000b%+\u0001\u0019A\u001e\t\u000b\u0001,\u0001\u0019\u0001'\u0002\u0013\u0019\u0014x.\\%oI\u0016D\u0018!E8cMV\u001c8-\u0019;f!>\u001c\u0018\u000e^5p]R\u00191\r]9\u0011\t\u0011D'N[\u0007\u0002K*\u0011amZ\u0001\tMVt7\r^5p]*\u0011\u0011gH\u0005\u0003S\u0016\u0014\u0001BR;oGRLwN\u001c\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[V\tqa\u001a:ba\"$'-\u0003\u0002pY\ni\u0011J\u001c9viB{7/\u001b;j_:DQ!\u0013\u0004A\u0002mBQA\u001d\u0004A\u00021\u000bq\u0002\u001d:fa\u0006\u00148/\u001a:PM\u001a\u001cX\r^\u0001\tM&tG\rT5oKR\u0019A*\u001e<\t\u000b%;\u0001\u0019A\u001e\t\u000b]<\u0001\u0019\u0001'\u0002\r=4gm]3u\u0003U\u0019\u0015\u0010\u001d5feF+XM]=PE\u001a,8oY1u_J\u0004\"aN\u0005\u0014\u0005%Y\bCA'}\u0013\ti\u0018I\u0001\u0004B]f\u0014VM\u001a\u000b\u0002s\u0006\u0011rJ\u0011$V'\u000e\u000bE+\u0012#`\u0019&#VIU!M+\t\t\u0019\u0001E\u0002\u001d\u0003\u000bI!AR\u000f\u0002'=\u0013e)V*D\u0003R+Ei\u0018'J)\u0016\u0013\u0016\t\u0014\u0011\u0002\u0015=\u0013e)V*D\u0003R+E)\u0006\u0002\u0002\u000eA!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014Y\u000b\u0001b\u001d;pe\u0006\u0014G.Z\u0005\u0005\u0003/\t\tBA\u0005UKb$h+\u00197vK\u0006YqJ\u0011$V'\u000e\u000bE+\u0012#!\u0003\u0015\t\u0007\u000f\u001d7z)\r\u0019\u0013q\u0004\u0005\u0007\u0003Cy\u0001\u0019\u0001\u0018\u0002'=\u0014g-^:dCRLwN\\'fi\u0006$\u0017\r^1")
public class CypherQueryObfuscator
implements QueryObfuscator {
    private final ObfuscationMetadata state;

    public static QueryObfuscator apply(ObfuscationMetadata obfuscationMetadata) {
        return CypherQueryObfuscator$.MODULE$.apply(obfuscationMetadata);
    }

    public String obfuscateText(String rawQueryText, int preParserOffset) {
        if (this.state.sensitiveLiteralOffsets().isEmpty()) {
            return rawQueryText;
        }
        StringBuilder sb = new StringBuilder();
        IntRef i = IntRef.create((int)0);
        this.state.sensitiveLiteralOffsets().foreach((Function1 & Serializable)literalOffset -> {
            CypherQueryObfuscator.$anonfun$obfuscateText$1(this, preParserOffset, rawQueryText, i, sb, literalOffset);
            return BoxedUnit.UNIT;
        });
        Object object = i.elem < rawQueryText.length() ? sb.append(rawQueryText.substring(i.elem)) : BoxedUnit.UNIT;
        return sb.toString();
    }

    public MapValue obfuscateParameters(MapValue rawQueryParameters) {
        if (this.state.sensitiveParameterNames().isEmpty()) {
            return rawQueryParameters;
        }
        ObjectRef params = ObjectRef.create((Object)rawQueryParameters);
        this.state.sensitiveParameterNames().foreach((Function1 & Serializable)p -> {
            params.elem = ((MapValue)params.elem).updatedWith(p, (AnyValue)CypherQueryObfuscator$.MODULE$.org$neo4j$cypher$internal$CypherQueryObfuscator$$OBFUSCATED());
            return BoxedUnit.UNIT;
        });
        return (MapValue)params.elem;
    }

    private int literalStringLength(String rawQueryText, int fromIndex) {
        char first = rawQueryText.charAt(fromIndex);
        if (first == '\"' || first == '\'') {
            for (int lastCharacterIndex = fromIndex; lastCharacterIndex < rawQueryText.length() - 1; ++lastCharacterIndex) {
                if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(rawQueryText), lastCharacterIndex) == '\\' || StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(rawQueryText), lastCharacterIndex + 1) != first) continue;
                return lastCharacterIndex - fromIndex + 2;
            }
            throw new IllegalStateException("Expected to find closing quote.");
        }
        return rawQueryText.length() - fromIndex;
    }

    public Function<InputPosition, InputPosition> obfuscatePosition(String rawQueryText, int preparserOffset) {
        if (this.state.sensitiveLiteralOffsets().isEmpty()) {
            return Function.identity();
        }
        return in -> {
            IntRef obfuscatedOffset = IntRef.create((int)in.getOffset());
            IntRef obfuscatedColumn = IntRef.create((int)in.getColumn());
            int obfuscatedLength = CypherQueryObfuscator$.MODULE$.org$neo4j$cypher$internal$CypherQueryObfuscator$$OBFUSCATED_LITERAL().length();
            int lineOffset = this.findLine(rawQueryText, preparserOffset);
            $this.state.sensitiveLiteralOffsets().foreach((Function1 & Serializable)literalOffset -> {
                CypherQueryObfuscator.$anonfun$obfuscatePosition$2(this, preparserOffset, in, rawQueryText, obfuscatedOffset, obfuscatedLength, lineOffset, obfuscatedColumn, literalOffset);
                return BoxedUnit.UNIT;
            });
            return new InputPosition(obfuscatedOffset.elem, in.getLine(), obfuscatedColumn.elem);
        };
    }

    private int findLine(String rawQueryText, int offset) {
        if (offset == 0) {
            return 0;
        }
        return (int)StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(rawQueryText), offset + 1).lines().count() - 1;
    }

    public static final /* synthetic */ void $anonfun$obfuscateText$1(CypherQueryObfuscator $this, int preParserOffset$1, String rawQueryText$1, IntRef i$1, StringBuilder sb$1, LiteralOffset literalOffset) {
        int start = literalOffset.start(preParserOffset$1);
        if (start >= rawQueryText$1.length() || start < i$1.elem) {
            throw new IllegalStateException("Literal offset out of bounds: " + literalOffset + ".");
        }
        sb$1.append(rawQueryText$1.substring(i$1.elem, start));
        sb$1.append(CypherQueryObfuscator$.MODULE$.org$neo4j$cypher$internal$CypherQueryObfuscator$$OBFUSCATED_LITERAL());
        i$1.elem = start + BoxesRunTime.unboxToInt((Object)literalOffset.length().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> $this.literalStringLength(rawQueryText$1, start)));
    }

    public static final /* synthetic */ void $anonfun$obfuscatePosition$2(CypherQueryObfuscator $this, int preparserOffset$1, InputPosition in$1, String rawQueryText$2, IntRef obfuscatedOffset$1, int obfuscatedLength$1, int lineOffset$1, IntRef obfuscatedColumn$1, LiteralOffset literalOffset) {
        int start = literalOffset.start(preparserOffset$1);
        if (start < in$1.getOffset()) {
            int length = BoxesRunTime.unboxToInt((Object)literalOffset.length().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> $this.literalStringLength(rawQueryText$2, start)));
            obfuscatedOffset$1.elem += obfuscatedLength$1 - length;
            if (literalOffset.line(lineOffset$1) == in$1.getLine()) {
                obfuscatedColumn$1.elem += obfuscatedLength$1 - length;
                return;
            }
            return;
        }
    }

    public CypherQueryObfuscator(ObfuscationMetadata state) {
        this.state = state;
    }
}

