/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import org.neo4j.cypher.internal.CacheTracer;
import org.neo4j.cypher.internal.ExecutionEngineQueryCacheMonitor;
import org.neo4j.cypher.internal.QueryCache;
import scala.Option;

public class MonitoringCacheTracer
implements CacheTracer<QueryCache.CacheKey<String>> {
    private final ExecutionEngineQueryCacheMonitor monitor;

    public MonitoringCacheTracer(ExecutionEngineQueryCacheMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void queryCacheHit(QueryCache.CacheKey<String> queryKey, String metaData) {
        this.monitor.cacheHit(queryKey);
    }

    @Override
    public void queryCacheMiss(QueryCache.CacheKey<String> queryKey, String metaData) {
        this.monitor.cacheMiss(queryKey);
    }

    @Override
    public void queryCompile(QueryCache.CacheKey<String> queryKey, String metaData) {
        this.monitor.cacheCompile(queryKey);
    }

    @Override
    public void queryCompileWithExpressionCodeGen(QueryCache.CacheKey<String> queryKey, String metaData) {
        this.monitor.cacheCompileWithExpressionCodeGen(queryKey);
    }

    @Override
    public void queryCacheStale(QueryCache.CacheKey<String> queryKey, int secondsSincePlan, String metaData, Option<String> maybeReason) {
        this.monitor.cacheDiscard(queryKey, metaData, secondsSincePlan, maybeReason);
    }

    @Override
    public void queryCacheFlush(long sizeOfCacheBeforeFlush) {
        this.monitor.cacheFlushDetected(sizeOfCacheBeforeFlush);
    }
}

