/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import org.neo4j.cypher.internal.CypherRuntime;
import org.neo4j.cypher.internal.ExecutionPlan;
import org.neo4j.cypher.internal.ExecutionPlanWithNotifications;
import org.neo4j.cypher.internal.LogicalQuery;
import org.neo4j.cypher.internal.RuntimeContext;
import org.neo4j.cypher.internal.SchemaCommandRuntime$;
import org.neo4j.cypher.internal.compiler.RuntimeUnsupportedNotification;
import org.neo4j.cypher.internal.options.CypherRuntimeOption;
import org.neo4j.cypher.internal.options.CypherRuntimeOption$default$;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.RecordingNotificationLogger;
import org.neo4j.cypher.internal.util.RecordingNotificationLogger$;
import org.neo4j.exceptions.CantCompileQueryException;
import org.neo4j.exceptions.RuntimeUnsupportedException;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u00114A\u0001C\u0005\u0001%!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u0015\u0011\u0005\u0001\"\u0011D\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u0015\t\u0006\u0001\"\u0003S\u0011\u0015A\u0006\u0001\"\u0011Z\u0005=1\u0015\r\u001c7cC\u000e\\'+\u001e8uS6,'B\u0001\u0006\f\u0003!Ig\u000e^3s]\u0006d'B\u0001\u0007\u000e\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011abD\u0001\u0006]\u0016|GG\u001b\u0006\u0002!\u0005\u0019qN]4\u0004\u0001U\u00111\u0003I\n\u0004\u0001QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\rE\u0002\u001c9yi\u0011!C\u0005\u0003;%\u0011QbQ=qQ\u0016\u0014(+\u001e8uS6,\u0007CA\u0010!\u0019\u0001!Q!\t\u0001C\u0002\t\u0012qaQ(O)\u0016CF+\u0005\u0002$MA\u0011Q\u0003J\u0005\u0003KY\u0011qAT8uQ&tw\r\u0005\u0002\u001cO%\u0011\u0001&\u0003\u0002\u000f%VtG/[7f\u0007>tG/\u001a=u\u0003!\u0011XO\u001c;j[\u0016\u001c\bcA\u0016459\u0011A&\r\b\u0003[Aj\u0011A\f\u0006\u0003_E\ta\u0001\u0010:p_Rt\u0014\"A\f\n\u0005I2\u0012a\u00029bG.\fw-Z\u0005\u0003iU\u00121aU3r\u0015\t\u0011d#\u0001\tsKF,Xm\u001d;fIJ+h\u000e^5nKB\u0011\u0001hO\u0007\u0002s)\u0011!(C\u0001\b_B$\u0018n\u001c8t\u0013\ta\u0014HA\nDsBDWM\u001d*v]RLW.Z(qi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0004\u007f\u0001\u000b\u0005cA\u000e\u0001=!)\u0011f\u0001a\u0001U!)ag\u0001a\u0001o\u0005!a.Y7f+\u0005!\u0005CA#J\u001d\t1u\t\u0005\u0002.-%\u0011\u0001JF\u0001\u0007!J,G-\u001a4\n\u0005)[%AB*ue&twM\u0003\u0002I-\u0005Q2m\u001c:sKN\u0004xN\u001c3j]\u001e\u0014VO\u001c;j[\u0016|\u0005\u000f^5p]V\ta\nE\u0002\u0016\u001f^J!\u0001\u0015\f\u0003\r=\u0003H/[8o\u0003M\u0001XO\u00197jG\u000e\u000bgN\\8u\u0007>l\u0007/\u001b7f)\t\u00193\u000bC\u0003U\r\u0001\u0007Q+A\tpe&<\u0017N\\1m\u000bb\u001cW\r\u001d;j_:\u0004\"a\u000b,\n\u0005]+$!C#yG\u0016\u0004H/[8o\u0003M\u0019w.\u001c9jY\u0016$v.\u0012=fGV$\u0018M\u00197f)\rQVL\u0019\t\u00037mK!\u0001X\u0005\u0003\u001b\u0015CXmY;uS>t\u0007\u000b\\1o\u0011\u0015qv\u00011\u0001`\u00031awnZ5dC2\fV/\u001a:z!\tY\u0002-\u0003\u0002b\u0013\taAj\\4jG\u0006d\u0017+^3ss\")1m\u0002a\u0001=\u000591m\u001c8uKb$\b")
public class FallbackRuntime<CONTEXT extends RuntimeContext>
implements CypherRuntime<CONTEXT> {
    private final Seq<CypherRuntime<CONTEXT>> runtimes;
    private final CypherRuntimeOption requestedRuntime;

    @Override
    public String name() {
        return "fallback";
    }

    @Override
    public Option<CypherRuntimeOption> correspondingRuntimeOption() {
        return this.runtimes.collectFirst((PartialFunction)new Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends CypherRuntime<CONTEXT>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1.correspondingRuntimeOption().isDefined() ? A1.correspondingRuntimeOption().get() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(CypherRuntime<CONTEXT> x1) {
                CypherRuntime<CONTEXT> cypherRuntime = x1;
                boolean bl = cypherRuntime.correspondingRuntimeOption().isDefined();
                return bl;
            }
        });
    }

    private Nothing$ publicCannotCompile(Exception originalException) {
        throw new RuntimeUnsupportedException(originalException.getMessage(), (Throwable)originalException);
    }

    @Override
    public ExecutionPlan compileToExecutable(LogicalQuery logicalQuery, CONTEXT context) {
        RecordingNotificationLogger logger = new RecordingNotificationLogger(RecordingNotificationLogger$.MODULE$.$lessinit$greater$default$1());
        Throwable lastException = null;
        for (int i = 0; i < this.runtimes.length(); ++i) {
            CypherRuntime runtime = (CypherRuntime)this.runtimes.apply(i);
            try {
                ExecutionPlan plan = runtime.compileToExecutable(logicalQuery, context);
                Set notifications = logger.notifications();
                ExecutionPlan notifiedPlan = notifications.isEmpty() ? plan : new ExecutionPlanWithNotifications(plan, (Set<InternalNotification>)notifications);
                return notifiedPlan;
            }
            catch (CantCompileQueryException e) {
                lastException = e;
                CypherRuntime cypherRuntime = runtime;
                SchemaCommandRuntime$ schemaCommandRuntime$ = SchemaCommandRuntime$.MODULE$;
                if (!(cypherRuntime == null ? schemaCommandRuntime$ != null : !cypherRuntime.equals(schemaCommandRuntime$))) continue;
                CypherRuntimeOption cypherRuntimeOption = this.requestedRuntime;
                CypherRuntimeOption$default$ cypherRuntimeOption$default$ = CypherRuntimeOption$default$.MODULE$;
                if (!(cypherRuntimeOption == null ? cypherRuntimeOption$default$ != null : !cypherRuntimeOption.equals(cypherRuntimeOption$default$))) continue;
                logger.log((InternalNotification)new RuntimeUnsupportedNotification(e.getMessage()));
                continue;
            }
            catch (Exception e) {
                lastException = e;
                ((RuntimeContext)context).log().debug(new StringBuilder(33).append("Runtime ").append(runtime.getClass().getSimpleName()).append(" failed to compile query ").append(logicalQuery.queryText()).toString(), (Throwable)e);
            }
        }
        Throwable throwable = lastException;
        if (throwable instanceof CantCompileQueryException) {
            CantCompileQueryException cantCompileQueryException = (CantCompileQueryException)throwable;
            throw this.publicCannotCompile((Exception)((Object)cantCompileQueryException));
        }
        throw throwable;
    }

    public FallbackRuntime(Seq<CypherRuntime<CONTEXT>> runtimes, CypherRuntimeOption requestedRuntime) {
        this.runtimes = runtimes;
        this.requestedRuntime = requestedRuntime;
    }
}

