/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import org.neo4j.cypher.CypherRuntimeOption;
import org.neo4j.cypher.CypherRuntimeOption$default$;
import org.neo4j.cypher.internal.CypherRuntime;
import org.neo4j.cypher.internal.ExecutionPlan;
import org.neo4j.cypher.internal.ExecutionPlanWithNotifications;
import org.neo4j.cypher.internal.LogicalQuery;
import org.neo4j.cypher.internal.RuntimeContext;
import org.neo4j.cypher.internal.SchemaCommandRuntime$;
import org.neo4j.cypher.internal.compiler.RuntimeUnsupportedNotification;
import org.neo4j.cypher.internal.v4_0.frontend.phases.RecordingNotificationLogger;
import org.neo4j.cypher.internal.v4_0.frontend.phases.RecordingNotificationLogger$;
import org.neo4j.cypher.internal.v4_0.util.InternalNotification;
import org.neo4j.exceptions.CantCompileQueryException;
import org.neo4j.exceptions.RuntimeUnsupportedException;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001%4A!\u0001\u0002\u0001\u0017\tya)\u00197mE\u0006\u001c7NU;oi&lWM\u0003\u0002\u0004\t\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u0006\r\u000511-\u001f9iKJT!a\u0002\u0005\u0002\u000b9,w\u000e\u000e6\u000b\u0003%\t1a\u001c:h\u0007\u0001)\"\u0001D\r\u0014\u0007\u0001i1\u0003\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0004)U9R\"\u0001\u0002\n\u0005Y\u0011!!D\"za\",'OU;oi&lW\r\u0005\u0002\u001931\u0001A!\u0002\u000e\u0001\u0005\u0004Y\"aB\"P\u001dR+\u0005\fV\t\u00039}\u0001\"AD\u000f\n\u0005yy!a\u0002(pi\"Lgn\u001a\t\u0003)\u0001J!!\t\u0002\u0003\u001dI+h\u000e^5nK\u000e{g\u000e^3yi\"A1\u0005\u0001B\u0001B\u0003%A%\u0001\u0005sk:$\u0018.\\3t!\r)Sf\u0005\b\u0003M-r!a\n\u0016\u000e\u0003!R!!\u000b\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0012B\u0001\u0017\u0010\u0003\u001d\u0001\u0018mY6bO\u0016L!AL\u0018\u0003\u0007M+\u0017O\u0003\u0002-\u001f!A\u0011\u0007\u0001B\u0001B\u0003%!'\u0001\tsKF,Xm\u001d;fIJ+h\u000e^5nKB\u00111\u0007N\u0007\u0002\t%\u0011Q\u0007\u0002\u0002\u0014\u0007f\u0004\b.\u001a:Sk:$\u0018.\\3PaRLwN\u001c\u0005\u0006o\u0001!\t\u0001O\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007eR4\bE\u0002\u0015\u0001]AQa\t\u001cA\u0002\u0011BQ!\r\u001cA\u0002IBQ!\u0010\u0001\u0005By\nAA\\1nKV\tq\b\u0005\u0002A\t:\u0011\u0011I\u0011\t\u0003O=I!aQ\b\u0002\rA\u0013X\rZ3g\u0013\t)eI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0007>AQ\u0001\u0013\u0001\u0005\n%\u000b1\u0003];cY&\u001c7)\u00198o_R\u001cu.\u001c9jY\u0016$\"\u0001\b&\t\u000b-;\u0005\u0019\u0001'\u0002#=\u0014\u0018nZ5oC2,\u0005pY3qi&|g\u000e\u0005\u0002&\u001b&\u0011aj\f\u0002\n\u000bb\u001cW\r\u001d;j_:DQ\u0001\u0015\u0001\u0005BE\u000b1cY8na&dW\rV8Fq\u0016\u001cW\u000f^1cY\u0016$BAU+[9B\u0011AcU\u0005\u0003)\n\u0011Q\"\u0012=fGV$\u0018n\u001c8QY\u0006t\u0007\"\u0002,P\u0001\u00049\u0016\u0001\u00047pO&\u001c\u0017\r\\)vKJL\bC\u0001\u000bY\u0013\tI&A\u0001\u0007M_\u001eL7-\u00197Rk\u0016\u0014\u0018\u0010C\u0003\\\u001f\u0002\u0007q#A\u0004d_:$X\r\u001f;\t\u000fu{\u0005\u0013!a\u0001=\u0006y1/Z2ve&$\u0018pQ8oi\u0016DH\u000f\u0005\u0002`O6\t\u0001M\u0003\u0002bE\u0006A1/Z2ve&$\u0018P\u0003\u0002dI\u0006\u0019\u0011\r]5\u000b\u0005\u00154\u0017AB6fe:,GN\u0003\u0002\u0004\r%\u0011\u0001\u000e\u0019\u0002\u0010'\u0016\u001cWO]5us\u000e{g\u000e^3yi\u0002")
public class FallbackRuntime<CONTEXT extends RuntimeContext>
implements CypherRuntime<CONTEXT> {
    private final Seq<CypherRuntime<CONTEXT>> runtimes;
    private final CypherRuntimeOption requestedRuntime;

    @Override
    public SecurityContext compileToExecutable$default$3() {
        return CypherRuntime.compileToExecutable$default$3$(this);
    }

    @Override
    public String name() {
        return "fallback";
    }

    private Nothing$ publicCannotCompile(Exception originalException) {
        throw new RuntimeUnsupportedException(originalException.getMessage(), (Throwable)originalException);
    }

    @Override
    public ExecutionPlan compileToExecutable(LogicalQuery logicalQuery, CONTEXT context, SecurityContext securityContext) {
        RecordingNotificationLogger logger = new RecordingNotificationLogger(RecordingNotificationLogger$.MODULE$.$lessinit$greater$default$1());
        Throwable lastException = null;
        for (int i = 0; i < this.runtimes.length(); ++i) {
            CypherRuntime runtime = (CypherRuntime)this.runtimes.apply(i);
            try {
                ExecutionPlan plan = runtime.compileToExecutable(logicalQuery, context, runtime.compileToExecutable$default$3());
                Set notifications = logger.notifications();
                ExecutionPlan notifiedPlan = notifications.isEmpty() ? plan : new ExecutionPlanWithNotifications(plan, (Set<InternalNotification>)notifications);
                return notifiedPlan;
            }
            catch (CantCompileQueryException e) {
                lastException = e;
                CypherRuntime cypherRuntime = runtime;
                SchemaCommandRuntime$ schemaCommandRuntime$ = SchemaCommandRuntime$.MODULE$;
                if (!(cypherRuntime == null ? schemaCommandRuntime$ != null : !cypherRuntime.equals(schemaCommandRuntime$))) continue;
                CypherRuntimeOption cypherRuntimeOption = this.requestedRuntime;
                CypherRuntimeOption$default$ cypherRuntimeOption$default$ = CypherRuntimeOption$default$.MODULE$;
                if (!(cypherRuntimeOption == null ? cypherRuntimeOption$default$ != null : !cypherRuntimeOption.equals(cypherRuntimeOption$default$))) continue;
                logger.log((InternalNotification)new RuntimeUnsupportedNotification(e.getMessage()));
                continue;
            }
            catch (Exception e) {
                lastException = e;
                ((RuntimeContext)context).log().debug(new StringBuilder(33).append("Runtime ").append(runtime.getClass().getSimpleName()).append(" failed to compile query ").append(logicalQuery.queryText()).toString(), (Throwable)e);
            }
        }
        Throwable throwable = lastException;
        if (throwable instanceof CantCompileQueryException) {
            CantCompileQueryException cantCompileQueryException = (CantCompileQueryException)throwable;
            throw this.publicCannotCompile((Exception)((Object)cantCompileQueryException));
        }
        throw throwable;
    }

    public FallbackRuntime(Seq<CypherRuntime<CONTEXT>> runtimes, CypherRuntimeOption requestedRuntime) {
        this.runtimes = runtimes;
        this.requestedRuntime = requestedRuntime;
    }
}

