/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.export;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;

public class SubGraphExporter {
    private final SubGraph graph;

    public SubGraphExporter(SubGraph graph) {
        this.graph = graph;
    }

    public void export(PrintWriter out) {
        this.appendIndexes(out);
        this.appendConstraints(out);
        this.appendNodes(out);
        this.appendRelationships(out);
    }

    private Collection<String> exportIndexes() {
        ArrayList<String> result = new ArrayList<String>();
        for (IndexDefinition index : this.graph.getIndexes()) {
            if (index.isConstraintIndex()) continue;
            Iterator propertyKeys = index.getPropertyKeys().iterator();
            if (!propertyKeys.hasNext()) {
                throw new IllegalStateException("Indexes should have at least one property key");
            }
            String key = this.quote((String)propertyKeys.next());
            if (propertyKeys.hasNext()) {
                throw new RuntimeException("Exporting compound indexes is not implemented yet");
            }
            String label = this.quote(index.getLabel().name());
            result.add("create index on :" + label + "(" + key + ")");
        }
        Collections.sort(result);
        return result;
    }

    private Collection<String> exportConstraints() {
        ArrayList<String> result = new ArrayList<String>();
        for (ConstraintDefinition constraint : this.graph.getConstraints()) {
            if (!constraint.isConstraintType(ConstraintType.UNIQUENESS)) {
                throw new RuntimeException("Exporting constraints other than uniqueness is not implemented yet");
            }
            Iterator propertyKeys = constraint.getPropertyKeys().iterator();
            if (!propertyKeys.hasNext()) {
                throw new IllegalStateException("Constraints should have at least one property key");
            }
            String key = this.quote((String)propertyKeys.next());
            if (propertyKeys.hasNext()) {
                throw new RuntimeException("Exporting compound constraints is not implemented yet");
            }
            String label = this.quote(constraint.getLabel().name());
            result.add("create constraint on (n:" + label + ") assert n." + key + " is unique");
        }
        Collections.sort(result);
        return result;
    }

    private String quote(String id) {
        return "`" + id + "`";
    }

    private String labelString(Node node) {
        Iterator labels = node.getLabels().iterator();
        if (!labels.hasNext()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        while (labels.hasNext()) {
            Label next2 = (Label)labels.next();
            result.append(":").append(this.quote(next2.name()));
        }
        return result.toString();
    }

    private String identifier(Node node) {
        return "_" + node.getId();
    }

    private void appendIndexes(PrintWriter out) {
        for (String line : this.exportIndexes()) {
            out.println(line);
        }
    }

    private void appendConstraints(PrintWriter out) {
        for (String line : this.exportConstraints()) {
            out.println(line);
        }
    }

    private void appendRelationships(PrintWriter out) {
        for (Node node : this.graph.getNodes()) {
            for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                this.appendRelationship(out, rel);
            }
        }
    }

    private void appendRelationship(PrintWriter out, Relationship rel) {
        out.print("create (");
        out.print(this.identifier(rel.getStartNode()));
        out.print(")-[:");
        out.print(this.quote(rel.getType().name()));
        this.formatProperties(out, (PropertyContainer)rel);
        out.print("]->(");
        out.print(this.identifier(rel.getEndNode()));
        out.println(")");
    }

    private void appendNodes(PrintWriter out) {
        for (Node node : this.graph.getNodes()) {
            this.appendNode(out, node);
        }
    }

    private void appendNode(PrintWriter out, Node node) {
        out.print("create (");
        out.print(this.identifier(node));
        String labels = this.labelString(node);
        if (!labels.isEmpty()) {
            out.print(labels);
        }
        this.formatProperties(out, (PropertyContainer)node);
        out.println(")");
    }

    private void formatProperties(PrintWriter out, PropertyContainer pc) {
        if (!pc.getPropertyKeys().iterator().hasNext()) {
            return;
        }
        out.print(" ");
        String propertyString = this.formatProperties(pc);
        out.print(propertyString);
    }

    private String formatProperties(PropertyContainer pc) {
        StringBuilder result = new StringBuilder();
        List keys = Iterables.toList((Iterable)pc.getPropertyKeys());
        Collections.sort(keys);
        for (String prop : keys) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(this.quote(prop)).append(":");
            Object value = pc.getProperty(prop);
            result.append(this.toString(value));
        }
        return "{" + result + "}";
    }

    private String toString(Iterator<?> iterator) {
        StringBuilder result = new StringBuilder();
        while (iterator.hasNext()) {
            if (result.length() > 0) {
                result.append(", ");
            }
            Object value = iterator.next();
            result.append(this.toString(value));
        }
        return "[" + result + "]";
    }

    private String arrayToString(Object value) {
        StringBuilder result = new StringBuilder();
        int length = Array.getLength(value);
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(this.toString(Array.get(value, i)));
        }
        return "[" + result + "]";
    }

    private String escapeString(String value) {
        return "\"" + value.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"") + "\"";
    }

    private String toString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return this.escapeString((String)value);
        }
        if (value instanceof Float || value instanceof Double) {
            return String.format(Locale.ENGLISH, "%f", value);
        }
        if (value instanceof Iterator) {
            return this.toString((Iterator)value);
        }
        if (value instanceof Iterable) {
            return this.toString(((Iterable)value).iterator());
        }
        if (value.getClass().isArray()) {
            return this.arrayToString(value);
        }
        return value.toString();
    }
}

