/*
 * Decompiled with CFR 0.152.
 */
package cypher.feature.parser.reporting;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.batik.svggen.SVGGraphics2D;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.w3c.dom.Document;

public class CoverageChartWriter {
    private final File outDirectory;
    private final String filename;
    private static final int HORIZONTAL_LINE_VALUE = 100;
    private JFreeChart cached = null;

    public CoverageChartWriter(File outDirectory, String filename) {
        this.outDirectory = outDirectory;
        this.filename = filename;
    }

    public void dumpSVG(Map<String, Integer> data) {
        try {
            SVGGraphics2D svgGenerator = new SVGGraphics2D(this.getDocument());
            this.createBarChart(data).draw((Graphics2D)svgGenerator, (Rectangle2D)new Rectangle(1500, 500));
            try (OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(new File(this.outDirectory, this.filename + ".svg")));){
                svgGenerator.stream((Writer)writer, true);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to write test report chart to SVG: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    private Document getDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation().createDocument(null, "svg", null);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Unexpected error during DOM document creation", e);
        }
    }

    public void dumpPNG(Map<String, Integer> data) {
        try (FileOutputStream output = new FileOutputStream(new File(this.outDirectory, this.filename + ".png"));){
            ImageIO.write((RenderedImage)this.createBarChart(data).createBufferedImage(1500, 500), "png", output);
        }
        catch (Exception e) {
            System.err.println("Failed to write test report chart to PNG: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    private JFreeChart createBarChart(Map<String, Integer> data) {
        if (this.cached != null) {
            return this.cached;
        }
        JFreeChart chart = ChartFactory.createBarChart((String)"Spec suite tag distribution", (String)"Tags", (String)"Occurrences in queries", (CategoryDataset)this.createCategoryDataset(data));
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.addRangeMarker((Marker)new ValueMarker(100.0, (Paint)Color.BLACK, (Stroke)new BasicStroke(2.0f)));
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)ChartColor.DARK_RED);
        renderer.setBarPainter((BarPainter)new StandardBarPainter());
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)0.5235987755982988));
        this.cached = chart;
        return chart;
    }

    private CategoryDataset createCategoryDataset(Map<String, Integer> data) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Map.Entry<String, Integer> entry : data.entrySet()) {
            dataset.addValue((Number)entry.getValue(), (Comparable)((Object)"tag"), (Comparable)((Object)entry.getKey()));
        }
        return dataset;
    }
}

