/*
 * Decompiled with CFR 0.152.
 */
package cypher.feature.parser.reporting;

import java.awt.Color;
import java.awt.Paint;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartColor;
import org.jfree.chart.renderer.LookupPaintScale;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.data.general.DefaultHeatMapDataset;
import org.jfree.data.general.HeatMapDataset;
import org.jfree.data.general.HeatMapUtilities;
import org.opencypher.tools.io.HtmlTag;

public class CombinationChartWriter {
    private final File outDirectory;
    private final String filename;
    private final LookupPaintScale paintScale;
    static final int UPPER_BOUND = 10000;

    public CombinationChartWriter(File outDirectory, String filename) {
        this.outDirectory = outDirectory;
        this.filename = filename;
        this.paintScale = new LookupPaintScale(-1.0, 10000.0, (Paint)Color.WHITE);
        this.buildPaintScale();
    }

    private void buildPaintScale() {
        this.paintScale.add(-1.0, (Paint)ChartColor.BLACK);
        this.paintScale.add(0.0, (Paint)ChartColor.VERY_DARK_RED);
        this.paintScale.add(10.0, (Paint)ChartColor.DARK_RED);
        this.paintScale.add(25.0, (Paint)ChartColor.RED);
        this.paintScale.add(50.0, (Paint)ChartColor.LIGHT_RED);
        this.paintScale.add(75.0, (Paint)ChartColor.VERY_LIGHT_RED);
        this.paintScale.add(100.0, (Paint)ChartColor.VERY_LIGHT_GREEN);
        this.paintScale.add(150.0, (Paint)ChartColor.LIGHT_GREEN);
        this.paintScale.add(200.0, (Paint)ChartColor.GREEN);
        this.paintScale.add(300.0, (Paint)ChartColor.DARK_GREEN);
        this.paintScale.add(500.0, (Paint)ChartColor.VERY_DARK_GREEN);
    }

    void dumpPNG(List<List<Integer>> data) {
        try (FileOutputStream output = new FileOutputStream(new File(this.outDirectory, this.filename + ".png"));){
            ImageIO.write((RenderedImage)HeatMapUtilities.createHeatMapImage((HeatMapDataset)this.createHeatMapDataset(data), (PaintScale)this.paintScale), "png", output);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error during PNG file creation", e);
        }
    }

    public void dumpHTML(List<List<Integer>> data, List<String> tags) {
        this.dumpPNG(data);
        try (HtmlTag.Html html = HtmlTag.html((Path)new File(this.outDirectory, this.filename + ".html").toPath());
             HtmlTag body = html.body();){
            this.buildTable(body, data, tags);
            body.tag("img", new HtmlTag.Attribute[]{HtmlTag.attr((String)"src", (String)(this.filename + ".png"))});
        }
    }

    private void buildTable(HtmlTag body, List<List<Integer>> data, List<String> tags) {
        try (HtmlTag table = body.tag("table", new HtmlTag.Attribute[]{HtmlTag.attr((String)"border", (String)"1")});){
            for (int i = tags.size() - 1; i > -1; --i) {
                try (HtmlTag row = table.tag("tr", new HtmlTag.Attribute[0]);){
                    for (int j = 0; j < data.get(i).size(); ++j) {
                        if (j == i) {
                            String columns = String.valueOf(j + 1);
                            row.tag("td", new HtmlTag.Attribute[]{HtmlTag.attr((String)"colspan", (String)columns), HtmlTag.attr((String)"align", (String)"right")}).text(tags.get(i));
                            continue;
                        }
                        if (j <= i) continue;
                        row.tag("td", new HtmlTag.Attribute[]{HtmlTag.attr((String)"align", (String)"center"), HtmlTag.attr((String)"width", (String)"25px"), HtmlTag.attr((String)"height", (String)"25px")}).text(data.get(i).get(j).toString());
                    }
                    continue;
                }
            }
        }
    }

    private HeatMapDataset createHeatMapDataset(List<List<Integer>> data) {
        int magnification = 10;
        DefaultHeatMapDataset dataset = new DefaultHeatMapDataset(data.size() * magnification, data.size() * magnification, 0.0, (double)(data.size() * magnification), 0.0, (double)(data.size() * magnification));
        for (int i = data.size() - 1; i > -1; --i) {
            for (int j = 0; j < data.get(i).size(); ++j) {
                double z = j < i ? 10001.0 : (j == i ? -1.0 : (double)data.get(i).get(j).intValue());
                for (int xi = 0; xi < magnification; ++xi) {
                    for (int yi = 0; yi < magnification; ++yi) {
                        dataset.setZValue(j * magnification + yi, i * magnification + xi, z);
                    }
                }
            }
        }
        return dataset;
    }
}

